<?php
namespace app\customs;

use app\models\Usuario;
use app\models\FormaPago;
use Stripe\Subscription;
use Stripe\Stripe;
use app\models\Suscripcion;
use app\models\UsuarioSuscripcion;

class StripeUtils{
    const ESTADO_SIN_SUSCRIPCION = 0; // Sin registro en Olivia de pago. Estado solo de Olivia.
    const ESTADO_SIN_FORMA_PAGO = 1; // Sin forma automática de pago. Estado solo de Olivia.
    const ESTADO_PRUEBA = 2; // Período de prueba 'trialing' en Stripe
    const ESTADO_ACTIVA = 3; // Suscripción sin cobros pendientes, 'active' en Stripe.
    const ESTADO_INCOMPLETA = 4; // Si el intento de pago falla, 'incomplete' en Stripe.
    const ESTADO_INCOMPLETA_EXPIRADA = 5; //Si el pago no se cancela después de 23 días. 'incomplete_expired' en Stripe
    const ESTADO_CANCELADA = 6; //Si la suscripcion se ha cancelado, 'canceled' en Stripe.
    
    
    
    public static function StatusSuscripcion(){
        $usuario = \Yii::$app->user->identity;
        $id_usuario = 0;
        $suscripcion = $usuario->suscripcion;
        if(($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL 
                && $usuario->tipo == Usuario::ASISTENTE)
            || ($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA 
                    && $usuario->tipoUsuarioJerarquia != UsuarioSuscripcion::TIPO_ADMINISTRADOR)){
            $id_usuario = $suscripcion->id_usuario;
        }
        else{
            $id_usuario = $usuario->id;
        }
        $formaPago = FormaPago::findOne(['id' => $id_usuario]);
        if($formaPago == null || $formaPago->subcription_id == null || $formaPago->subcription_id == ''){
            return self::ESTADO_SIN_SUSCRIPCION;
        }
        
        $subscription = self::ObtenerSuscripcion($formaPago->subcription_id);
        $estado_stripe = self::EstadoSuscripcion($subscription->status);
        if($estado_stripe != self::ESTADO_PRUEBA){
            if($formaPago->pay_method == null || $formaPago->pay_method == ''){
                return self::ESTADO_SIN_FORMA_PAGO;
            }
        }
        return $estado_stripe;
    }
    
    public static function ObtenerSuscripcion($subscription_id){
        $secretStripeKey = \Yii::$app->params['strSKey'];
        Stripe::setApiKey($secretStripeKey);
        $subscription = Subscription::retrieve($subscription_id);
        return $subscription;

    }
    
    public static function EstadoSuscripcion($status){
        switch ($status){
            case Subscription::STATUS_ACTIVE:
                return self::ESTADO_ACTIVA;
            case Subscription::STATUS_TRIALING:
                return self::ESTADO_PRUEBA;
            case Subscription::STATUS_INCOMPLETE:
                return self::ESTADO_INCOMPLETA;
            case Subscription::STATUS_INCOMPLETE_EXPIRED:
                return self::ESTADO_INCOMPLETA_EXPIRADA;
            case Subscription::STATUS_CANCELED:
                return self::ESTADO_CANCELADA;
                
        }
    }
	
	public static function EstadoLabel($status){
        switch ($status){
            case Subscription::STATUS_ACTIVE:
                return "Activa";
            case Subscription::STATUS_TRIALING:
                return "Prueba";
            case Subscription::STATUS_INCOMPLETE:
                return "Incompleta";
            case Subscription::STATUS_INCOMPLETE_EXPIRED:
                return "Incompleta expirada";
            case Subscription::STATUS_CANCELED:
                return "Cancelada";
                
        }
        
    }
}