<?php

namespace app\customs;

use bizley\quill\Quill;

/**
 * Description of QuiiEditorConf
 *
 * @author Nasser
 */
class QuiiEditorConf {
    
    
    private static $toolbarOptions = [
        ['bold', 'italic', 'underline', 'strike'],          // toggled buttons
        ['blockquote'],
        [[ 'list' => 'ordered'], [ 'list'=> 'bullet' ]],
        [[ 'script' => 'sub'], [ 'script'=> 'super' ]],      // superscript/subscript
        [[ 'indent' => '-1'], [ 'indent'=> '+1' ]],          // outdent/indent
        [[ 'direction' => 'rtl' ]],                          // text direction
        [[ 'header' => [1, 2, 3, 4, 5, 6, false] ]],
        [[ 'color' => [] ], [ 'background'=> [] ]],          // dropdown with defaults from theme
        [[ 'align' => [] ]],
        ['link'],   
        ['clean']   
    ];


    public static function init($id='quill', $placeholder='Escribe algo...'){
        return Quill::widget([
                'id' => $id, 
                'name' => $id,
                'theme' => 'snow',
                'placeholder' => $placeholder,
                'toolbarOptions' => self::$toolbarOptions
            ]); 
    }
}
