<?php

namespace app\controllers;

use Yii;
use app\models\Paciente;
use app\models\Usuario;
use app\models\Pais;
use yii\filters\VerbFilter;
use yii\web\Response;
use app\customs\BaseController;
use yii\db\Expression;
use app\models\DiaDisponible;
use app\models\Evento;
use app\models\Cita;
use app\models\HorarioMedico;
use app\models\CitaEvento;
use app\customs\Utils;
use app\customs\SesionUtils;
use app\models\Suscripcion;
use app\models\web\CitaWeb;

class UtilsController extends BaseController {
    //put your code here
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'pacientes' => ['post'],
                    'paises' => ['post'],
                    'validar-fecha' => ['post'],
                ],
            ],
        ];
    }
    
    public function actionPacientes(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $id_suscripcion = $suscripcion->id;
        $text = $post["text"];
        $query = Paciente::find()
                ->where(['id_suscripcion' => $id_suscripcion]);
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $query->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        }
        if(count(explode(' ', $text)) > 1){
            $filtroWhere = ['OR'];
            foreach (explode(' ', $text) as $item){
                $filtroWhere[] = [
                        'OR',
                        ['LIKE', 'lower(nombre)', \strtolower($item) . '%', false],
                        ['LIKE', 'lower(nombre)', '% ' . \strtolower($item) . '%', false]
                    ];
                $filtroWhere[] = [
                        'OR',
                        ['LIKE', 'lower(apellido)', \strtolower($item) . '%', false],
                        ['LIKE', 'lower(apellido)', '% ' . \strtolower($item) . '%', false]
                    ];
                $filtroWhere[] = [
                        'OR',
                        ['LIKE', 'lower(nombre_encargado)', \strtolower($item) . '%', false],
                        ['LIKE', 'lower(nombre_encargado)','% ' . \strtolower($item) . '%', false]
                    ];
            }
            $query->andFilterWhere($filtroWhere);
        }
        else{
            $query->andFilterWhere([
                    'or',
                    ['like','nombre',$text . '%', false],
                    ['like','nombre','% ' . $text . '%', false],
                    ['like','apellido',$text . '%', false],
                    ['like','apellido','% ' . $text . '%', false],
                    ['like','nombre_encargado',$text . '%', false],
                    ['like','nombre_encargado','% ' . $text . '%', false]
                ]);
        }
        $pacientes =  $query->all();
        
        return ['Correcto'=>true,'Pacientes'=>$pacientes];
    }
    
    public function actionPacientesSelect2(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $get = Yii::$app->request->get();
        $result=[];
        if(isset($get["term"])){
            $usuario = Yii::$app->user->identity;
            $id_suscripcion = $usuario->suscripcion->id;
            $text = $get["term"];
            $query = Paciente::find()->where(['id_suscripcion' => $id_suscripcion]);
            if(count(explode(' ', $text)) > 1){
                $filtroWhere = ['OR'];
                foreach (explode(' ', $text) as $item){
                    $filtroWhere[] = [
                            'OR',
                            ['LIKE', 'lower(nombre)', \strtolower($item) . '%', false],
                            ['LIKE', 'lower(nombre)', '% ' . \strtolower($item) . '%', false]
                        ];
                    $filtroWhere[] = [
                            'OR',
                            ['LIKE', 'lower(apellido)', \strtolower($item) . '%', false],
                            ['LIKE', 'lower(apellido)', '% ' . \strtolower($item) . '%', false]
                        ];
                    $filtroWhere[] = [
                            'OR',
                            ['LIKE', 'lower(nombre_encargado)', \strtolower($item) . '%', false],
                            ['LIKE', 'lower(nombre_encargado)','% ' . \strtolower($item) . '%', false]
                        ];
                }
                $query->andFilterWhere($filtroWhere);
            } else {
                $query->andFilterWhere([
                        'or',
                        ['like','nombre',$text . '%', false],
                        ['like','nombre','% ' . $text . '%', false],
                        ['like','apellido',$text . '%', false],
                        ['like','apellido','% ' . $text . '%', false],
                        ['like','nombre_encargado',$text . '%', false],
                        ['like','nombre_encargado','% ' . $text . '%', false]
                    ]);
            }
            $pacientes = $query->all();
            
            foreach($pacientes as $paciente){
                $result[] = ['id' => $paciente->id, 'text' => $paciente->nombreCompleto.($paciente->codigo == null ? ' (No definido)' : ' ('.$paciente->codigo.')')];
            }
        }
        return ['results' => $result];
    }
    
    
    public function actionPaises(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $text = $post["text"];
        $query = Pais::find()->where([
                'or',
                ['like','nombre',$text],
                ['like','iso',$text]
            ]);
        $paises =  $query->all();
        
        return ['Correcto'=>true,'Paises'=>$paises];
    }
    
    
    public function actionPacientesPorFecha(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $usuario = Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id;
        $opt = $post['opt'];
        $query = Paciente::find()
                ->join('INNER JOIN','cita','paciente.id = cita.id_paciente')
                ->select(["paciente.id","paciente.nombre","paciente.apellido","paciente.email"])
                ->where(['cita.id_suscripcion' => $id_suscripcion]);
        switch ($opt){
            case 'custom':
                $start = $post['start'];
                $end = $post['end'];
                $fechaI = \DateTime::createFromFormat('d/m/Y', $start)->format('Y-m-d');
                $fechaF = \DateTime::createFromFormat('d/m/Y', $end)->format('Y-m-d');
                $query->andWhere(['between','cita.fecha',$fechaI,$fechaF]);
                break;
            case 'today':
                $query->andWhere(['=',new Expression('DATE(cita.fecha)'), new Expression('DATE(\'' . \date("Y-m-d H:i:s") . '\')')]);
                break;
            default:
                $query->andWhere([
                        'between',
                        new Expression('DATE(cita.fecha)'),
                        new Expression('DATE(\'' . \date("Y-m-d H:i:s") . '\')'),
                        new Expression('DATE(DATE_ADD(\'' . \date("Y-m-d H:i:s") . '\', INTERVAL +7 DAY))')
                    ]);
                break;
        }
                
        $pacientes =  $query->distinct()->all();
        
        return ['Correcto'=>true,'Pacientes'=>$pacientes];
    }
    
    
    public function actionValidarFecha(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $id_suscripcion = $suscripcion->id;
        $validarHorario = boolval($post["validarHorario"]);
        
        
        $id_clinica = ($usuario->tipo == Usuario::DOCTOR) ? $post['id_clinica'] : SesionUtils::ClinicaSeleccionada()->id;
        $minutos = $post["minutos"];
        $id_cita = 0;
        $fecha = \DateTime::createFromFormat('d/m/Y H:i', $post["fecha"])->format('Y-m-d H:i');
        if(isset($post["id_cita"])){
            $id_cita = $post["id_cita"];
        }
        $totalHorario = 1;
        if($validarHorario){
            $totalHorario = $this->totalHorarios($fecha,$minutos,$id_suscripcion,$id_clinica);
        }
        $totalCita = $this->totalCitas($fecha,$minutos,$id_suscripcion,$id_cita,$id_clinica);
        $totalEvento = $this->totalEventos($fecha,$minutos,$id_suscripcion,$suscripcion);
        list( $existeSolicitud, $solicitud ) = $this->solicitudCitaPorFechaHora( $fecha, $id_suscripcion, $minutos );
        return ['Correcto'=>true,'FechaValida'=> ($totalHorario > 0 && $totalCita == 0) && $totalEvento == 0, 'existeSolicitud' =>$existeSolicitud, 'solicitud'=>$solicitud];
    }
    
    
    public function actionValidarFechaEvento(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $id_suscripcion = $suscripcion->id;
        $fecha_inicio = $post["fecha_inicio"];
        $fecha_fin = $post["fecha_fin"];
        $id_evento = $post["id_evento"];
        $todoDia = filter_var($post["todo_dia"],FILTER_VALIDATE_BOOLEAN);
        $fecha_inicio = \DateTime::createFromFormat($todoDia ? 'd/m/Y' : 'd/m/Y H:i', $fecha_inicio)->format($todoDia ? 'Y-m-d' : 'Y-m-d H:i');
        if(!$todoDia){
            $fecha_fin = \DateTime::createFromFormat('d/m/Y H:i', $fecha_fin)->format('Y-m-d H:i');
        }
        $totalHorario = 1;
        $totalCita = $this->totalCitasParaEventos($fecha_inicio,$fecha_fin,$id_suscripcion,$todoDia,$suscripcion);
        $totalEvento = $this->totalEventosParaEventos($fecha_inicio,$fecha_fin,$id_suscripcion,$id_evento,$todoDia,$suscripcion);
        return ['Correcto'=>true,'FechaValida'=> ($totalHorario > 0 && $totalCita == 0) && $totalEvento == 0];
    }
    
    
    public function actionValidarCalendario(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $id_suscripcion = $suscripcion->id;
        $fecha = $post["fecha"];
        $duracion = $post["duracion"];
        $id_clinica = ($usuario->tipo == Usuario::DOCTOR) ? $post['id_clinica'] : SesionUtils::ClinicaSeleccionada()->id;
        $id_cita = 0;
        if(isset($post["id_cita"])){
            $id_cita = $post["id_cita"];
        }
        $dias = DiaDisponible::obtenerDiasNoDisponibles($fecha, $id_suscripcion,$id_clinica,$duracion,$id_cita,$suscripcion);
        return ['Correcto'=>true,'Dias' => $dias,'Fecha' => $fecha];
    }
    
    // <editor-fold defaultstate="collapsed" desc="Validacion Hora - Minutos">
    public function actionObtenerHorasNoHabiles(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $id_suscripcion = $suscripcion->id;
        
        $fecha = $post["fecha"];
        $duracion = $post["duracion"];
        $id_cita = isset($post['id_cita']) ? intval($post['id_cita']) : 0;
        $id_clinica = ($usuario->tipo == Usuario::DOCTOR) ? $post['id_clinica'] : SesionUtils::ClinicaSeleccionada()->id;
        $horarios = $this->HorariosDia($id_suscripcion,$id_clinica,$fecha);
        if(count($horarios) == 0){
            return ['Correcto'=>true,'Minutos' => Utils::AllDay(),'Horas' => Utils::AllHours(),'Fecha' => $fecha];
        }
        $start = strtotime('00:00');
        $time = time();
        $end = strtotime('23:59');
        $llave = 0;
        $slotlist = [];
        $horas = [];
        foreach($horarios as $horario){
            $end = strtotime($horario->hora_inicio);
            $slotlist = $this->minutos($horas,$slotlist,$llave,$start,$end);
            $start = strtotime($horario->hora_fin) - (($duracion - 5)*60);
            $llave = intval(\date('H',$start));
        }
        $end = strtotime('23:59');
        $mins = [];
        $slotlist = $this->minutos($horas,$slotlist,$llave,$start,$end);
        $this->minutosHorasCitaEvento($id_suscripcion,$id_clinica,$fecha,$duracion,$horas,$slotlist,$id_cita,$suscripcion);
        $disponible = $this->disponible($slotlist,$fecha);
        return ['Correcto'=>true,'Minutos' => $slotlist,'Horas' => $horas,'Fecha' => $fecha, 'Disponible'=>$disponible];
    }
    
    /**
     * Armar minutos disponibles apartir de los no disponibles
     * @param Array $slotlist minutos no disponibles por hora
     * @return Array 
     */
    private function disponible($slotlist,$fecha){
        $disponible = [];
        $minutos = [0,5,10,15,20,25,30,35,40,45,50,55];
        for($i = 0; $i < 24; $i++){
            $key = 'h'.$i;
            if(!(array_key_exists($key,$slotlist))){
                $disponible += [$key => $minutos];
            } else {
                $disp = [];
                $keyPos = $slotlist[$key];
                for($j = 0; $j < count($minutos); $j++){
                    if(!in_array($minutos[$j],$keyPos)){
                        $disp[] = $minutos[$j];
                    }
                }
                if(count($disp)>0){
                    $disponible += [$key => $disp];   
                }
            }
        }
        $horarios = [];
        $keys = array_keys($disponible);
        $hoy = date('Y-m-d H:i');
        $hora_actual = date('g:i A', strtotime($hoy));
        if(count($keys) > 0){
            for($i = 0; $i < count($keys); $i++){
                $nH = substr($keys[$i],1);
                $h = $nH < 10 ? '0'.$nH : $nH;
                $am_pm = $nH > 11 ? ' PM' : ' AM';
                $minutos = $disponible[$keys[$i]];
                for($j = 0; $j < count($minutos); $j++){
                    $hora_minutos_final = ($h < 13 ? $h : '0'.$h-12 ).':'.($minutos[$j] < 10 ? '0'.$minutos[$j] : $minutos[$j]).$am_pm;
                    if(strtotime($fecha) == strtotime(explode(' ', $hoy)[0])){
                        if(strtotime($hora_minutos_final) >= strtotime($hora_actual)){
                            $horarios[] = $hora_minutos_final; 
                        }  
                    } else {
                        $horarios[] = $hora_minutos_final; 
                    }
                }
            }
        }
        return $horarios;
    }
    /**
     * 
     * @param int $id_suscripcion
     * @param int $id_clinica
     * @param string $fecha
     * @param int $duracion
     * @param string $horasFin
     * @param string $minutosFin
     * @param int $idCita
     * @param Suscripcion $suscripcion
     */
    private function minutosHorasCitaEvento($id_suscripcion, $id_clinica, $fecha,
            $duracion,&$horasFin,&$minutosFin,$idCita,$suscripcion = null){
        
        $minutos=[];
        $horas = [];
        $citaEventos = CitaEvento::obtenerCitaEventos($id_suscripcion, $id_clinica, $fecha, $duracion,$idCita,$suscripcion);
        foreach($citaEventos as $citaEvento){
            $start = strtotime($citaEvento->fecha);
            $llave = intval(\date('H',$start));
            $end = strtotime($citaEvento->fecha_fin);
            for( $i = $start; $i < $end; $i += (60*5)) 
            {
                $horaInt = intval(\date('H',$i));
                $nextHora = intval(\date('H',$i + (60*5)));
                $mins[] = intval(\date('i',$i));
                $hhkey = 'h'.$llave;
                if($horaInt != $nextHora){
                    if(key_exists($hhkey,$minutos)){
                        $minutos[$hhkey] = array_unique(array_merge($mins,$minutos[$hhkey]));
                    }
                    else{
                        $minutos[$hhkey] = $mins;
                    }
                    $horas[] = $llave;
                    $mins = [];
                    $llave = $nextHora;
                }
                else if(($i + (60*5)) >= $end){
                    //$minutos['h' .$llave] = $mins;
                    if(key_exists($hhkey,$minutos)){
                        $minutos[$hhkey] = array_unique(array_merge($mins,$minutos[$hhkey]));
                    }
                    else{
                        $minutos[$hhkey] = $mins;
                        
                    }
                    $horas[] = $llave;
                    $mins = [];
                }
            }
        }
        $horas = array_unique($horas);
        foreach($horas as $hora){
            $hkey = 'h'.$hora;
            if(key_exists($hkey,$minutosFin)){
                $minutosFin[$hkey] = array_unique(array_merge($minutos[$hkey],$minutosFin[$hkey]));
            }
            else{
                $minutosFin[$hkey] = $minutos[$hkey];
            }
            if(count($minutosFin[$hkey]) == 12 && in_array($hora, $horasFin) == FALSE){
                $horasFin[] = $hora;
            }
        }
    }
    
    private function minutos(&$horas,$minutos,$llave,$start,$end){
        $mins = [];
        for( $i = $start; $i < $end; $i += (60*5)) 
        {
            $horaInt = intval(\date('H',$i));
            $nextHora = intval(\date('H',$i + (60*5)));
            $mins[] = intval(\date('i',$i));
            $hkey = 'h' .$llave;
            if($horaInt != $nextHora){
                if(key_exists($hkey,$minutos)){
                    $minutos[$hkey] = array_unique(array_merge($mins,$minutos[$hkey]));
                }
                else{
                    $minutos[$hkey] = $mins;
                }
                
                if(count($mins) == 12){
                    $horas[] = $llave;
                }
                $mins = [];
                $llave = $nextHora;
            }
            else if(($i + (60*5)) >= $end){
                if(key_exists($hkey,$minutos)){
                    $minutos[$hkey] = array_unique(array_merge($mins,$minutos[$hkey]));
                }
                else{
                    $minutos[$hkey] = $mins;
                }
            }
        }
        return $minutos;
    }
    
    private function HorariosDia($id_suscripcion,$id_clinica,$fecha){
        return HorarioMedico::find()->where(['id_suscripcion' => $id_suscripcion])
                ->andFilterWhere(['id_clinica' => $id_clinica])
                ->andFilterWhere(['dia' => new Expression('DAYOFWEEK(\'' . $fecha . '\')')])
                ->orderBy(['hora_inicio' => SORT_ASC])->all();
    }
    // </editor-fold>
    
    
    private function solicitudCitaPorFechaHora($fecha,$id_suscripcion,$minutos){
        $fecha_fin_cita = \date('Y-m-d H:i:s', \strtotime($fecha.'+'.$minutos.' minutes'));
        $db = CitaWeb::getDB();
        $strQueryId = 'SELECT id FROM cita WHERE id_suscripcion ='.$id_suscripcion. ' AND '. 'estado ='.CitaWeb::ACTIVA. ' AND ('.
                            new Expression('DATE_ADD(\''.$fecha.'\', INTERVAL 1 MINUTE)').' BETWEEN fecha AND '.
                            new Expression('DATE_ADD(fecha, INTERVAL tiempo_estimado MINUTE)').' OR '.
                            new Expression('DATE_ADD(\''.$fecha_fin_cita.'\', INTERVAL -1 MINUTE)'). 'BETWEEN fecha AND '.
                            new Expression('DATE_ADD(fecha, INTERVAL tiempo_estimado MINUTE)').' OR '. 
                            'fecha and '. new Expression('DATE_ADD(fecha, INTERVAL tiempo_estimado MINUTE)'). 
                            ' BETWEEN \''.$fecha. '\' AND \''. $fecha_fin_cita .'\') LIMIT 1';
        $id = $db->createCommand($strQueryId)->queryOne();
        $solicitud = $id > 0 ? CitaWeb::findOne($id) : null;
        return ( $solicitud != null || !empty( $solicitud ) ) ? [ true, $this->formatResSolicitud($solicitud, $fechaCompleta=true)] : [ false, null ];
    }
    
    private function formatResSolicitud($solicitud, $fechaCompleta=false){
        return [                
                'id' => $solicitud->id,  
                'fecha' => $fechaCompleta ? $solicitud->fechaCompleta.' / '.date('g:i A', strtotime($solicitud->fechaFin)) : $solicitud->fechaCompleta,
                'fecha_expirada' => strtotime( date('Y-m-d H:i') ) > strtotime( $solicitud->fechaDB )  ? true : false,
                'tipoCita' => $solicitud->tipo_cita == CitaWeb::CITA_EN_LINEA ? 'Cita en línea' : 'Cita presencial', 
                'procedimientos' => $solicitud->primerProcedimiento->nombre, 
                'comentario' => ($solicitud->comentario != null || $solicitud->comentario != '') ? $solicitud->comentario : '(Sin comentarios del paciente)',
                'paciente' => [
                    'id' => $solicitud->paciente->id,
                    'nombreCorto' => $solicitud->paciente->nombreCorto,
                    'nombreCompleto' => $solicitud->paciente->nombreCompleto,
                ]
            ];
    }
    
    private function totalHorarios($fecha,$minutos,$id_suscripcion,$id_clinica){
        $query = Yii::$app->getDb();
        $strQueryHorario = "SELECT COUNT(*) total FROM horario_medico
                            WHERE (DAYOFWEEK('$fecha') = dia 
                                    AND TIME('$fecha') BETWEEN hora_inicio AND hora_fin)
                                AND (DAYOFWEEK(DATE_ADD('$fecha', INTERVAL $minutos MINUTE)) = dia 
                                    AND TIME(DATE_ADD('$fecha', INTERVAL $minutos MINUTE)) BETWEEN hora_inicio AND hora_fin)"
                . " AND id_suscripcion = $id_suscripcion AND id_clinica = " . $id_clinica;

        $totalHorario = $query->createCommand($strQueryHorario)->queryScalar();
        return $totalHorario;
    }
    
    private function totalCitas($fecha,$minutos,$id_suscripcion,$id_cita,$id_clinica){
        $query = Yii::$app->getDb();
        $strQueryCita = "SELECT COUNT(*) total FROM cita
                                WHERE ((('$fecha' > fecha) AND ('$fecha' < DATE_ADD(fecha,INTERVAL tiempo_estimado MINUTE)))
                                OR ((DATE_ADD('$fecha',INTERVAL ($minutos) MINUTE) > fecha) AND ((DATE_ADD('$fecha',INTERVAL ($minutos) MINUTE) < DATE_ADD(fecha,INTERVAL tiempo_estimado MINUTE)))))"
                                . " AND id_suscripcion = $id_suscripcion AND id_clinica = " . $id_clinica. " AND estado <> " . Cita::CANCELADA;
        if($id_cita != 0){
            $strQueryCita .= " AND id <>" . $id_cita;
        }
        $totalCita = $query->createCommand($strQueryCita)->queryScalar();
        return $totalCita;
    }
    

    /**
     * 
     * @param string $fecha
     * @param string $minutos
     * @param int $id_suscripcion
     * @param Suscripcion $suscripcion
     * @return int
     */
    private function totalEventos($fecha,$minutos,$id_suscripcion,$suscripcion = null){
        $query = Yii::$app->getDb();
        $strQueryEvento = "SELECT COUNT(*) total FROM evento
                                WHERE (('$fecha' > fecha_inicio) AND ('$fecha' < fecha_fin)
                                OR (DATE_ADD('$fecha',INTERVAL $minutos MINUTE) > fecha_fin) AND (DATE_ADD('$fecha',INTERVAL $minutos MINUTE) < fecha_fin))"
                                . " AND id_suscripcion = $id_suscripcion";
        if($suscripcion != null && $suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $strQueryEvento .= " AND id_clinica=" . SesionUtils::ClinicaSeleccionada()->id; 
        }
        $totalEvento = $query->createCommand($strQueryEvento)->queryScalar();
        return $totalEvento;
    }
    
    private function totalCitasParaEventos($fecha_inicio,$fecha_fin,$id_suscripcion,$todo_dia,$suscripcion){
        $qCita = Cita::find()->where(['id_suscripcion' => $id_suscripcion]);
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $qCita->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        }
        if($todo_dia){
            $qCita->andFilterWhere([
                    'OR',
                    ['=',new Expression('DATE(\'' . $fecha_inicio . '\')'),new Expression('DATE(fecha)')],
                    ['=',new Expression('DATE(\'' . $fecha_inicio . '\')'),new Expression('DATE(DATE_ADD(fecha,INTERVAL tiempo_estimado MINUTE))')]
                ]);
        }
        else{
            $qCita->andFilterWhere([
                    'OR',
                    ['AND',
                        ['<','fecha',$fecha_inicio],
                        ['>',new Expression('DATE_ADD(fecha,INTERVAL tiempo_estimado MINUTE)'),$fecha_inicio,]
                    ],
                    ['AND',
                        ['<','fecha',$fecha_fin],
                        ['>',new Expression('DATE_ADD(fecha,INTERVAL tiempo_estimado MINUTE)'),$fecha_fin]
                    ]
                ]);
        }
        $totalCita = $qCita->count();
        return $totalCita;
    }
    
    private function totalEventosParaEventos($fecha_inicio,$fecha_fin,$id_suscripcion,$id_evento,$todo_dia,$suscripcion){
        $qEvento = Evento::find()->where(['id_suscripcion' => $id_suscripcion]);
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $qEvento->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        }
        if($todo_dia){
            $qEvento->andFilterWhere([
                    'OR',
                    ['=',new Expression('DATE(\'' . $fecha_inicio . '\')'),new Expression('DATE(fecha_inicio)')],
                    ['=',new Expression('DATE(\'' . $fecha_inicio . '\')'),new Expression('DATE(fecha_fin)')]
                ]);
        }
        else{
            $qEvento->andFilterWhere([
                    'OR',
                    ['AND',
                        ['<','fecha_inicio',$fecha_inicio],
                        ['>','fecha_fin',$fecha_inicio]
                    ],
                    ['AND',
                        ['<','fecha_inicio',$fecha_fin],
                        ['>','fecha_fin',$fecha_fin]
                    ]
                ]);
        }
        
        if($id_evento != 0){
            $qEvento->andFilterWhere(['<>','id',$id_evento]);
        }
        $totalEvento = $qEvento->count();
        return $totalEvento;
    }
    

    public function excludeFromSecurity(){
         return [
             'validar-fecha',
             'pacientes',
             'paises',
             'validar-fecha-evento',
             'pacientes-por-fecha',
             'pacientes-select2',
             'validar-calendario',
             'obtener-horas-no-habiles',
             'obtener-minutos-no-habiles'];
    }
}
