<?php

namespace app\controllers;

use Yii;
use app\models\Suscripcion;
use yii\data\ActiveDataProvider;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Usuario;
use yii\helpers\ArrayHelper;
use app\models\Plan;
use app\models\Recordatorio;
use Stripe\Subscription;
use Stripe\Customer;
use Stripe\Stripe;
use app\models\Configuracion;
use app\models\ConfiguracionSuscripcion;
use app\models\FormaPago;
use app\models\Cupon;
use app\models\CuponSuscripcion;
use app\models\Pais;
/**
 * SuscripcionController implements the CRUD actions for Suscripcion model.
 */
class SuscripcionController extends BaseController {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Suscripcion models.
     * @return mixed
     */
    public function actionIndex() {
        $dataProvider = new ActiveDataProvider([
            'query' => Suscripcion::find(),
        ]);

        return $this->render('index', [
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Suscripcion model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Suscripcion model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $this->bodyClass = "suscripcion-form";
        $model = new Suscripcion();
        $post = Yii::$app->request->post();
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            if($post['id_cupon'] != null){
                $this->guardarCuponSuscripcion($model->id, $post['id_cupon']);
            }
            $this->crearConfNombrePublico($model);
            $this->crearRecordatorios($model->id);
            $this->asociarStripe($model);
            Yii::$app->session->setFlash('success','La suscripcion del usuario '.$model->usuario->nombre_usuario.' se ha guardado exitosamente');
            return $this->redirect(['view', 'id' => $model->id]);
        }
        $query = new \yii\db\Query();
        $usuariosFilter = $query->from(['s' => 'suscripcion'])
                                    ->select(['u.id','u.nombre_usuario',])
                                    ->rightJoin(['u' => 'usuario'],'`s`.`id_usuario` = `u`.`id`')
                                    ->where(['u.activo' => 1])                                 
                                    ->andWhere(['u.tipo' => 1])
                                    ->andWhere(['s.activa' => null])
                                    ->andWhere(['s.id' => null])
                                    ->andWhere(['s.id_plan'=> null])    
                                    ->all();
        
        $usuarios = ArrayHelper::map($usuariosFilter, "id", "nombre_usuario");
        $planes = ArrayHelper::map(Plan::findAll(['activo' => 1]), "id", "nombre");
        $cupones = ArrayHelper::map(Cupon::findAll(['activo' => 1]), "id", "nombre");
        $paises = ArrayHelper::map(Pais::find()->orderBy('nombre ASC')->where('moneda is not null')->all(), "id", "nombre");
        
        $model->stripe_activo = true;
        
        return $this->render('create', [
                    'model' => $model,
                    'usuarios' => $usuarios,
                    'planes' => $planes,
                    'cupones' => $cupones,
                    'paises' => $paises
        ]);
    }

    /**
     * Updates an existing Suscripcion model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $this->bodyClass = "suscripcion-form";
        $model = $this->findModel($id);
        
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success','La suscripcion del usuario '.$model->usuario->nombre_usuario.' se ha actualizado exitosamente');
            return $this->redirect(['view', 'id' => $model->id]);
        }
        $usuarios = ArrayHelper::map(Usuario::findAll(['tipo' => 1, 'activo' => 1]), "id", "nombre_usuario");
        $planes = ArrayHelper::map(Plan::findAll(['activo' => 1]), "id", "nombre");
        $cupones = ArrayHelper::map(Cupon::findAll(['activo' => 1]), "id", "nombre");
        $paises = ArrayHelper::map(Pais::find()->orderBy('nombre ASC')->where(['IS NOT','moneda', null])->all(), "id", "nombre");
        return $this->render('update', [
                    'model' => $model,
                    'usuarios' => $usuarios,
                    'planes' => $planes,
                    'cupones' => $cupones,
                    'paises' => $paises
        ]);
    }
    
    public function actionCambiarPlan($id){
        $this->bodyClass = "suscripcion-form";
        $model = $this->findModel($id);
        $post = Yii::$app->request->post();
        $planIdSus = $model->id_plan;
        $cuponSus = $model->cuponSuscripcion;
        $cuponSelectedId = $cuponSus != null ? $cuponSus->cupon->id : null;
        $time = time();
        if ($model->load(Yii::$app->request->post()) && $model->save()){
            CuponSuscripcion::deleteAll(['id_suscripcion'=>$model->id]);
            if($post['id_cupon'] != null){
                $cuponSus = $this->guardarCuponSuscripcion($model->id, $post['id_cupon']);
            }
            $cuponId = $cuponSus != null ? $cuponSus->cupon->stripe_id : null;
            if(($planIdSus != $model->id_plan) || ($cuponSelectedId != $post['id_cupon']) || ($cuponSus == null)){
                $plan = $model->plan;
                $formaPago = FormaPago::findOne(['id'=>$model->id_usuario]);
                if($formaPago != null){
                    $secretStripeKey = \Yii::$app->params['strSKey'];
                    Stripe::setApiKey($secretStripeKey);
                    $subscriptionId = $formaPago->subcription_id;
                    $subscriptionSource = Subscription::retrieve($subscriptionId);
                    $discount = $subscriptionSource->discount;
                    if($cuponId == null && $discount != null){
                        $subscriptionSource->deleteDiscount();
                    }
                    try{
                        Subscription::update($subscriptionId,[
                            'trial_from_plan' => false,
                            'cancel_at_period_end' => false,
                            'proration_behavior' => 'none',
                            ['coupon' => $cuponId],
                            'items' => [
                                [
                                    'id' => $subscriptionSource->items->data[0]->id,  
                                    'plan' => $plan->stripe_id,   
                                ],  
                            ],
                        ]);
                    }
                    catch(\Exception $ex){
                        \Yii::$app->session->setFlash("warning","Existe un error con su forma de pago, por favor revise su cuenta.<br/>" . $ex->getMessage());
                    }
                }
            }
            Yii::$app->session->setFlash('success','La suscripcion del usuario '.$model->usuario->nombre_usuario.' se ha actualizado exitosamente');
            return $this->redirect(['view', 'id' => $model->id]);
        }
        $usuarios = ArrayHelper::map(Usuario::findAll(['tipo' => 1, 'activo' => 1]), "id", "nombre_usuario");
        $planes = ArrayHelper::map(Plan::findAll(['activo' => 1]), "id", "nombre");
        $cupones = ArrayHelper::map(Cupon::findAll(['activo' => 1]), "id", "nombre");
        return $this->render('cambiar-plan', [
                        'model' => $model,
                        'usuarios' => $usuarios,
                        'planes' => $planes,
                        'cupones' => $cupones,
                        'cuponSelected' => $cuponSelectedId
                    ]);
    }
    
    private function guardarCuponSuscripcion($idSuscripcion,$idCupon){
        $cuponSus = new CuponSuscripcion();
        $cuponSus->id_suscripcion = $idSuscripcion;
        $cuponSus->id_cupon = $idCupon;
        $cuponSus->save();
        return $cuponSus; 
    }

    /**
     * Deletes an existing Suscripcion model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        $this->findModel($id)->delete();
        
        return $this->redirect(['index']);
    }

    private function crearRecordatorios($idSuscripcion) {
        $recor1 = new Recordatorio();
        $recor1->tiempo_previo = 5;
        $recor1->unidad_tiempo = Recordatorio::DIAS;
        $recor1->es_movil = true;
        $recor1->es_correo = true;
        $recor1->nombre = "Primer recordatorio";
        $recor1->activo = true;
        $recor1->id_suscripcion = $idSuscripcion;
        $recor1->save();

        $recor2 = new Recordatorio();
        $recor2->tiempo_previo = 24;
        $recor2->unidad_tiempo = Recordatorio::HORAS;
        $recor2->es_movil = true;
        $recor2->es_correo = true;
        $recor2->nombre = "Segundo recordatorio";
        $recor2->activo = true;
        $recor2->id_suscripcion = $idSuscripcion;
        $recor2->save();

        $recor3 = new Recordatorio();
        $recor3->tiempo_previo = 90;
        $recor3->unidad_tiempo = Recordatorio::MINUTOS;
        $recor3->es_movil = true;
        $recor3->es_correo = true;
        $recor3->nombre = "Tercer recordatorio";
        $recor3->activo = true;
        $recor3->id_suscripcion = $idSuscripcion;
        $recor3->save();
    }

    /**
     * Finds the Suscripcion model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Suscripcion the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = Suscripcion::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    /*
     * 
     * @param objet $model
     */
    private function crearConfNombrePublico($model){
        $conf = $this->findConfig('nombre_publico', $model->id);
        $conf->valor = $model->usuario->perfil->primerApellido;
        $conf->save();
    }
    
    /**
     * 
     * @param \app\models\Suscripcion $suscripcion
     * @return \app\controllers\FormaPago
     */
    private function asociarStripe($suscripcion){
        $secretStripeKey = \Yii::$app->params['strSKey'];
        Stripe::setApiKey($secretStripeKey);
        $cupon = $suscripcion->cuponSuscripcion;
        $cuponId = $cupon != null ? $cupon->cupon->stripe_id : null;
        $usuario = $suscripcion->usuario;
        $customerResult = Customer::create([
                    'email' => $usuario->nombre_usuario,
                    'name' => $usuario->perfil->nombreCompleto,
                    'description' => 'Sr(a) ' . $usuario->perfil->nombreCompleto . ' (Id: ' . $suscripcion->id . ')' . $suscripcion->email
        ]);
        $plan = $suscripcion->plan;
        $subcriptionResult = Subscription::create([
            'customer' => $customerResult->id,
            'trial_from_plan'=>true,
            ['coupon' => $cuponId],
            'items' => [
              [
                'plan' => $plan->stripe_id
              ],
            ],
        ]);
        
        $formaPago = new FormaPago();
        $formaPago->id = $usuario->id;
        $formaPago->created = $customerResult->created;
        $formaPago->currency = $customerResult->currency;
        $formaPago->customer_id = $customerResult->id;
        $formaPago->description = $customerResult->description;
        $formaPago->invoice_prefix = $customerResult->invoice_prefix;
        $formaPago->subcription_id = $subcriptionResult->id;
        $formaPago->save();
        return 
        ;
    }
            
    /*
     * 
     * @param string $llave
     * @param int $idSuscripcion
     * @return objet $model
     */
    protected function findConfig($llave, $idSuscripcion){
        $model = ConfiguracionSuscripcion::find()->where(['llave' => $llave])->andWhere(['id_suscripcion' => $idSuscripcion])->one();
        if ($model == null) {
            $configuracionGral = Configuracion::find()->where(['llave' => $llave])->one();
            $model = $configuracionGral->toSuscripcion();
            $model->id_suscripcion = $idSuscripcion;
            $model->save();
        }
        return $model;
    }

}
