<?php

namespace app\controllers;

use Yii;
use app\models\FormaPago;
use app\models\FormaPagoSearch;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Stripe\Stripe;
use Stripe\Subscription;
use Stripe\Customer;

/**
 * StripeController implements the CRUD actions for FormaPago model.
 */
class StripeController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all FormaPago models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new FormaPagoSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single FormaPago model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $formaPago = $this->findModel($id);
        $secretStripeKey = \Yii::$app->params['strSKey'];
        Stripe::setApiKey($secretStripeKey);
        $customer = $formaPago->getStripeCustomer();
        $subscription = '';
        $invoices = '';
        if(!is_string($customer)){
            $subscription = $formaPago->getStripeSuscription();
            $invoices = $formaPago->getStripeInvoices(5);
        }
        
        
        return $this->render('view', [
            'model' => $formaPago,
            'subscription' => is_string($subscription) ? null : $subscription,
            'mensaje_suscripcion' => is_string($subscription) ? $subscription : '',
            'customer' => is_string($customer) ? null : $customer,
            'mensaje_cliente' => is_string($customer) ? $customer : '',
            'invoices' => is_string($invoices) ? null : $invoices,
            'mensaje_facturas' => is_string($invoices) ? $invoices : ''
        ]);
    }

    /**
     * Creates a new FormaPago model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new FormaPago();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing FormaPago model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing FormaPago model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        
        $secretStripeKey = \Yii::$app->params['strSKey'];
        Stripe::setApiKey($secretStripeKey);
        try{
            $model = $this->findModel($id);
            $customer = Customer::retrieve(
                $model->customer_id
            );
            $customer->delete();
            $model->delete();
        }
        catch(\Exception $ex)
        {
            \Yii::$app->session->setFlash("danger","Ha ocurrido un error: " . $ex->getMessage());
        }
        return $this->redirect(['index']);
    }

    /**
     * Deletes an existing FormaPago model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDesuscribir($id)
    {
        $formaPago = $this->findModel($id);
        $secretStripeKey = \Yii::$app->params['strSKey'];
        Stripe::setApiKey($secretStripeKey);

        $subscription = Subscription::retrieve(
                $formaPago->subcription_id
        );
        $subscription->delete();
        
        $formaPago->subcription_id = null;
        $formaPago->save();
        $usuario = $formaPago->usuario;
        $usuario->activo = false;
        $usuario->save();
        return $this->redirect(['index']);
    }
    
    /**
     * Finds the FormaPago model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return FormaPago the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = FormaPago::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
