<?php

namespace app\controllers;

use Yii;
use app\models\ConfiguracionSuscripcion;
use yii\data\ActiveDataProvider;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Configuracion;
use yii\web\Response;
use app\customs\SesionUtils;
use app\models\Suscripcion;
use yii\helpers\Url;
//use bitcko\googlecalendar\GoogleCalendarApi;
use app\customs\GoogleCalendarApi;

use app\models\Pagadito;

/**
 * SettingsController implements the CRUD actions for ConfiguracionSuscripcion model.
 */
class SettingsController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all ConfiguracionSuscripcion models.
     * @return mixed
     */
    public function actionIndex()
    {
        $usuario = \Yii::$app->user->identity;
        $idSuscripcion = $usuario->suscripcion->id;
        $configuraciones = Configuracion::find()->select(['configuracion.llave','configuracion.tipo','configuracion.nombre','configuracion.valor','configuracion.descripcion', 'configuracion.posibles_valores', 'configuracion.orden'])
                ->leftJoin('configuracion_suscripcion','`configuracion_suscripcion`.`llave` = `configuracion`.`llave` AND `configuracion_suscripcion`.`id_suscripcion` = ' . $idSuscripcion)
                ->andWhere(['is', 'configuracion_suscripcion.llave', null])
                ->andWhere(['es_suscripcion' => TRUE])
                ->andWhere(['configuracion.visible' => 1])
                ->andWhere(['or',['es_clinica' => FALSE],['is','es_clinica', null]]);
        
        $configuracionesSuscripcion = ConfiguracionSuscripcion::find()->select(['llave','tipo','nombre','valor','descripcion', 'posibles_valores', 'orden'])
                ->where(['id_suscripcion' => $idSuscripcion])
                ->andWhere(['is','id_clinica', null])
                ->andFilterWhere(['visible' => 1]);

        $unionQuery = (new \yii\db\Query())
        ->from(['configuraciones' => $configuraciones->union($configuracionesSuscripcion)])
        ->orderBy(['llave' => SORT_ASC])
        ->orderBy(['orden' => SORT_ASC]);
        
        $dataProvider = new ActiveDataProvider([
            'query' => $unionQuery
        ]);
        




        $configs = (new \yii\db\Query())
        ->from(['configuraciones' => $configuraciones->union($configuracionesSuscripcion)])
        ->orderBy(['llave' => SORT_ASC])
        ->orderBy(['orden' => SORT_ASC])
        ->all();

        //Url que se envia en recordatorios  
        $confTeleConsulta = ConfiguracionSuscripcion::find()->where(['llave' => 'link_teleconsulta'])
                    ->andWhere(['id_suscripcion' => $idSuscripcion])
                    ->andWhere(['is','id_clinica',NULL])->one();
        if ($confTeleConsulta == null) {
            $confTeleConsulta = Configuracion::find()->where(['llave' => 'link_teleconsulta'])->one();
        }

        
        
        //Url donde redirecciona el icono de telemedicina en user_tool  
        $confMedioTeleConsulta = ConfiguracionSuscripcion::find()->where(['llave' => 'link_medio_teleconsulta'])
                    ->andWhere(['id_suscripcion' => $idSuscripcion])
                    ->andWhere(['is','id_clinica',NULL])->one();
        if ($confMedioTeleConsulta == null) {
            $confMedioTeleConsulta = Configuracion::find()->where(['llave' => 'link_medio_teleconsulta'])->one();
        }

        //configuracion del calendario
        $calendar_google = SesionUtils::configuracionSesion('google_calendar');
        $redirectUrl = Url::to(['/google-api/auth'],true);
        $calendarId = 'primary';
        $username=\Yii::$app->user->identity->suscripcion->email;
        $googleApi = new GoogleCalendarApi($username,$calendarId,$redirectUrl);
        $calendars = $googleApi->checkIfCredentialFileExists() ? $googleApi->calendarList() : null;
        //$googleApi->deleteCredentialFileExists();
        $url_auth_calendar = Url::to(['/google-api/auth']);
        $url_desvincular_calendar = Url::to(['/settings/desvincular-calendar']);
       
        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'configs' => $configs,
            'pagadito' => Pagadito::find()->where(['id_suscripcion' => $idSuscripcion])->one(),
            'teleconsultaConf' => $confTeleConsulta,
            'medioTeleconsultaConf' => $confMedioTeleConsulta,
            'admin' => true,
            'googlecalendarConf' => $calendar_google,
            'calendars' => $calendars,
            'url_auth_calendar'=>$url_auth_calendar,
            'url_desvincular_calendar'=>$url_desvincular_calendar
        ]);
    }

    
    
    /**
     * Lists all ConfiguracionSuscripcion models.
     * @return mixed
     */
    public function actionClinica()
    {
        $usuario = \Yii::$app->user->identity;
        $idSuscripcion = $usuario->suscripcion->id;
        $idClinica = SesionUtils::ClinicaSeleccionada()->id;
        $configuraciones = Configuracion::find()->select(['configuracion.llave','configuracion.tipo','configuracion.nombre','configuracion.valor','configuracion.descripcion', 'configuracion.posibles_valores', 'configuracion.orden'])
                ->leftJoin('configuracion_suscripcion','`configuracion_suscripcion`.`llave` = `configuracion`.`llave` AND `configuracion_suscripcion`.`id_suscripcion` = ' . $idSuscripcion . ' AND `configuracion_suscripcion`.`id_clinica` = ' . $idClinica)
                ->andWhere(['is', 'configuracion_suscripcion.llave', null])
                ->andWhere(['configuracion.visible' => 1])
                ->andWhere(['es_suscripcion' => TRUE,'es_clinica' => TRUE]);        
        
        $configuracionesSuscripcion = ConfiguracionSuscripcion::find()->select(['llave','tipo','nombre','valor','descripcion', 'posibles_valores', 'orden'])
                ->where(['id_suscripcion' => $idSuscripcion])
                ->where(['id_clinica' => $idClinica])
                ->andFilterWhere(['visible' => 1]);
        
        $unionQuery = (new \yii\db\Query())
        ->from(['configuraciones' => $configuraciones->union($configuracionesSuscripcion)])
        ->orderBy(['llave' => SORT_ASC])
        ->orderBy(['orden' => SORT_ASC]);
        
        $dataProvider = new ActiveDataProvider([
            'query' => $unionQuery
        ]);
                
        $configs = (new \yii\db\Query())
        ->from(['configuraciones' => $configuraciones->union($configuracionesSuscripcion)])
        ->orderBy(['llave' => SORT_ASC])
        ->orderBy(['orden' => SORT_ASC])
        ->all();

        //configuracion del calendario
        $calendar_google = SesionUtils::configuracionSesion('google_calendar');
        $redirectUrl = Url::to(['/google-api/auth'],true);
        $calendarId = 'primary';
        $username=\Yii::$app->user->identity->suscripcion->email;
        $googleApi = new GoogleCalendarApi($username,$calendarId,$redirectUrl);
        $calendars = $googleApi->checkIfCredentialFileExists() ? $googleApi->calendarList() : null;
        $url_auth_calendar = Url::to(['/google-api/auth']);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'configs' => $configs,
            'pagadito' => Pagadito::find()->where(['id_suscripcion' => $idSuscripcion])->one(),
            'teleconsultaConf' => SesionUtils::configuracionSesion('link_teleconsulta'),
            'admin' => false,
            'googlecalendarConf' => $calendar_google,
            'calendars' => $calendars,
            'url_auth_calendar' => $url_auth_calendar
        ]);
    }

   
    /**
     * Updates an existing ConfiguracionSuscripcion model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($llave)
    {
        $model = $this->findModel($llave);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }
    
    
    public function actionUpdateSetting(){
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        
        Yii::$app->response->format = Response::FORMAT_JSON;
        if (Yii::$app->request->isAjax) {
            $key =  filter_input(INPUT_POST, "id");
            $value =  filter_input(INPUT_POST, "valor");            
            $tipo =  filter_input(INPUT_POST, "tipo");
            $esAdminJerarquia = false;
            if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
                $esAdminJerarquia = filter_input(INPUT_POST, 'admin_jerarquia');
            }
            $model = $this->findModel($key,$esAdminJerarquia);
            $model->valor = $value;
            if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA && $esAdminJerarquia == false){
                $model->id_clinica = SesionUtils::ClinicaSeleccionada()->id;
            }
            $model->update();
            return ['Correcto'=>true];
        }
    }
    
    public function actionObtenerConfiguracion(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $post = Yii::$app->request->post();
        if (Yii::$app->request->isAjax) {
            $llave = $post['llave'];
            $esAdminJerarquia = false;
            if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
                $esAdminJerarquia = boolval($post['admin_jerarquia']);
            }
            $model = $this->findModel($llave,$esAdminJerarquia);
            return ['Correcto'=>true, 'model'=>$model];
        }
        return ['Correcto'=>false];
    }
    
    public function actionActualizarConfiguracion(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $post = Yii::$app->request->post(); 
        if ( Yii::$app->request->isAjax ) {
            $llave =  $post['llave'];
            $valor =  $post['valor'];
            $posibles_valores = $post['posibles_valores'];
            $esAdminJerarquia = false;
            if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
                $esAdminJerarquia = $post['admin_jerarquia'];
            }
            $model = $this->findModel($llave,$esAdminJerarquia);
            $model->posibles_valores = $posibles_valores;
            $model->valor = $valor;
            if( $model->save() ){
                return ['Correcto'=>true, 'model'=>$model];
            }
            return ['Correcto'=>false];
        }
    }

    

    /**
     * Finds the ConfiguracionSuscripcion model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ConfiguracionSuscripcion the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id,$esAdminJerarquia = false)
    {
        
        $usuario = \Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $idSuscripcion =  $suscripcion->id;
        $modelQuery = ConfiguracionSuscripcion::find()->where(['llave' => $id])->andWhere(['id_suscripcion' => $idSuscripcion]);
        $esSuscripcionJerarquizada = $suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA;
        if($esSuscripcionJerarquizada && $esAdminJerarquia == false){
            $modelQuery->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        }
        else{
            $modelQuery->andWhere(['is','id_clinica',NULL]);
        }
        $model = $modelQuery->one();
        if ($model == null) {
            $configuracionGral = Configuracion::find()->where(['llave' => $id])->one();
            $model = $configuracionGral->toSuscripcion($esSuscripcionJerarquizada, $esAdminJerarquia);
            $model->id_suscripcion = $idSuscripcion;
            $model->save();
        }
        return $model;
    }
    
    public function beforeAction($action) {
        if ($action->id == 'obtener-configuracion') {
            $this->enableCsrfValidation = false;
        }

        return parent::beforeAction($action);
    }


    public function excludeFromSecurity() {
        return ['desvincular-calendar','actualizar-configuracion', 'obtener-configuracion','update-setting'];
    }


    public function actionDesvincularCalendar(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
         
        
        //if ( Yii::$app->request->isAjax ) {
            $llave =  'google_calendar';
            $valor =  NULL;
            $posibles_valores = NULL;
            $esAdminJerarquia = false;
            $model = $this->findModel($llave,$esAdminJerarquia);
            $model->posibles_valores = $posibles_valores;
            $model->valor = $valor;
            if( $model->save() ){
                $redirectUrl = Url::to(['/google-api/auth'],true);
                $calendarId = 'primary';
                $username= \Yii::$app->user->identity->suscripcion->email;
                $googleApi = new GoogleCalendarApi($username,$calendarId,$redirectUrl);                
                $googleApi->deleteCredentialFileExists();
                return ['Correcto'=>true, 'model'=>$model];
            }
            return ['Correcto'=>false];
        //}
    }
}
