<?php

namespace app\controllers;

use Yii;
use app\models\Seguimiento;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Usuario;
use app\models\Cita;
use app\models\Paciente;
use app\models\BitacoraSeguimiento;
use yii\web\Response;
use \app\customs\SesionUtils;
use app\models\repositories\SecurityFunctions;
use app\models\Suscripcion;
use yii\helpers\Url;
/**
 * EventoController implements the CRUD actions for Seguimiento model.
 */
class SeguimientoController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Seguimiento models.
     * @return mixed
     */
    public function actionIndex()
    {
        $usuario = Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id;
        return $this->render('index');
    }
    
    public function actionCitasAsistencia(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $securityFunctions = new SecurityFunctions();
        $toolCita = $securityFunctions->accionPermitida("confirmar-cita", "cita") ? true : false;
        $usuario = Yii::$app->user->identity;
        $requestData = $_REQUEST;
        $db = Cita::getDb();
        $columns = [
            0 => 'codigo',
            1 => 'nombre',
            2 => 'fecha'
        ];
        $sql = "SELECT c.id, p.id as id_paciente, p.codigo, p.nombre, p.apellido, c.fecha "
                . "FROM cita c INNER JOIN paciente p ON p.id = c.id_paciente "
                . "WHERE c.fecha <= '".date('Y-m-d H:i:s')."' "
                . "AND c.id_suscripcion = ".$usuario->suscripcion->id
                . " AND ( c.estado = ".Cita::AGENDADA." OR c.estado = ".Cita::CONFIRMADA." OR c.estado = ".Cita::REPROGRAMADA.")";
        if( $usuario->suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA ){
            $sql .= " AND c.id_clinica = " . SesionUtils::ClinicaSeleccionada()->id;
        }
        $data = $db->createCommand($sql)->queryAll();
        $totalData = count($data);
        $totalFiltered = $totalData;
        if(!empty($requestData['search']['value'])){
            $sql.=" AND ( p.nombre LIKE '" . $requestData['search']['value'] . "%' ";
            $sql.=" OR p.nombre LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql.=" OR p.apellido LIKE '" . $requestData['search']['value'] . "%' ";
            $sql.=" OR c.fecha LIKE '" . $requestData['search']['value'] . "%' ";
            $sql.=" OR c.fecha LIKE '%" . $requestData['search']['value'] . "%' ) ";
        }
        $data = $db->createCommand($sql)->queryAll();
        $totalFiltered = count($data);
        $sql.=" ORDER BY " . $columns[$requestData['order'][0]['column']] . "   " . $requestData['order'][0]['dir'] . "  LIMIT " . $requestData['start'] . " ," . 
        $requestData['length'] . "   ";
        $result = $db->createCommand($sql)->queryAll();
        $data = [];
        foreach($result as $key => $row){
             $fecha = \DateTime::createFromFormat('Y-m-d H:i:s',$row["fecha"])->format('d/m/Y H:i');
             $nestedData = [];
             $nestedData[] = $row['id'];
             $nestedData[] = $row['id_paciente'];
             $nestedData[] = $row['codigo'] != null ? $row["codigo"] : 'No definido';
             $nestedData[] = $row['nombre'].' '.$row['apellido'];
             $nestedData[] = $fecha;
             $nestedData[] = '<button data-id="'.$row['id'].'" class="btn btn-outline-success" onclick="btnClickSi('.$row["id"].');" style="margin:1px; width: 45px;">Sí</button>
                              <button data-id="'.$row['id'].'" class="btn btn-outline-danger" onclick="btnClickNo('.$row["id"].');" style="margin:1px; width: 45px;">No</button>';
             $data[] = $nestedData;
        }
        $json_data = [
            "draw" => intval($requestData['draw']), 
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data   // citas asistencia
        ];
        return $json_data;
    }
    
    /**
     * 
     * @param app\models\Usuario $usuario
     * @param app\models\repositories\SecurityFunctions $securityFunctions
     * @return Array
     */
    private function obtenerCitas($usuario,$securityFunctions){
        $date = ('Y-m-d H:i:s');
        $qCitas = Cita::find()
            ->where(['id_suscripcion' => $usuario->suscripcion->id])
            ->andWhere(['<=', 'fecha', date('Y-m-d H:i:s')])
            ->andWhere(['or',['estado' => Cita::AGENDADA],['estado' => Cita::CONFIRMADA],['estado' => Cita::REPROGRAMADA]]);
        if($usuario->tipo == Usuario::ASISTENTE){
            $qCitas->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        }
        $citas = $qCitas->all();
        $result = [];
        $confimarCita = $securityFunctions->accionPermitida("confirmar-cita", "cita") ? true : false;
        foreach($citas as $cita){
            $fecha = \DateTime::createFromFormat('d/m/Y H:i', $cita->fecha)->format('Y-m-d H:i');
            $result[] = [
                    'pacienteId'     => $cita->paciente->id,
                    'pacienteNombre' => $cita->paciente->nombreCompleto,
                    'pacienteCodigo' => $cita->paciente->codigo != null ? $cita->paciente->codigo : 'No definido',
                    'estadoCita'     => $cita->estado,
                    'citaFecha'      => $cita->fecha,
                    'citaId'         => $cita->id,
                    'citaConf'       => $confimarCita
                ];
        }
        return $result;
    }
     
    public function actionSeguimientos(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $now = date('Y-m-d');
        $requestData = $_REQUEST;
        $db = Seguimiento::getDb();
        $baseUrl = Url::base();
        $columns = [
            0 => 'codigo',
            1 => 'nombre',   
            2 => 'fecha_seguimiento',
            3 => 'motivo'
        ];
        $sql = "SELECT  s.id, p.id as id_paciente, p.codigo, p.nombre, p.apellido, s.fecha_seguimiento, s.hora_seguimiento, s.motivo "
                . "FROM seguimiento s "
                . "INNER JOIN paciente p ON p.id = s.id_paciente WHERE s.estado = 0 "
                . "AND s.id_suscripcion = " . $usuario->suscripcion->id;
        if( $usuario->suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA ){
            $sql .= " AND s.id_clinica = " . SesionUtils::ClinicaSeleccionada()->id;
        }
        $data = $db->createCommand($sql)->queryAll();
        $totalData = count($data);
        $totalFiltered = $totalData;
        if (!empty($requestData['search']['value'])){
            $sql.=" AND ( p.nombre LIKE '" . $requestData['search']['value'] . "%' ";
            $sql.=" OR p.nombre LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql.=" OR p.apellido LIKE '" . $requestData['search']['value'] . "%' ";
            $sql.=" OR p.apellido LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql.=" OR p.codigo LIKE '" . $requestData['search']['value'] . "%' ";
            $sql.=" OR p.codigo LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql.=" OR s.fecha_seguimiento LIKE '" . $requestData['search']['value'] . "%' ";
            $sql.=" OR s.fecha_seguimiento LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql.=" OR s.motivo LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql.=" OR s.motivo LIKE '" . $requestData['search']['value'] . "%') ";
        } 
        $data = $db->createCommand($sql)->queryAll();
        $totalFiltered = count($data);
        $sql.=" ORDER BY " . $columns[$requestData['order'][0]['column']] . "   " . $requestData['order'][0]['dir'] . "  LIMIT " . $requestData['start'] . " ," . 
        $requestData['length'] . "   ";
        $result = $db->createCommand($sql)->queryAll();
        $data = [];        
        foreach ($result as $key => $row){
            $fecha = \DateTime::createFromFormat('Y-m-d',$row["fecha_seguimiento"])->format('d/m/Y');
            $classCSS = \strtotime($now) > \strtotime($row["fecha_seguimiento"]) ? 'no-valid' : (\strtotime($now) == \strtotime($row["fecha_seguimiento"]) ? 'now' : '');
            $nestedData = [];
            $nestedData[] = $row["id"];
            $nestedData[] = $classCSS;
            $nestedData[] = $row["codigo"] != null ? $row["codigo"] : 'No definido';
            $nestedData[] = $row["nombre"].' '.$row["apellido"];            
            $nestedData[] = $fecha.' '. substr($row["hora_seguimiento"],0,5);
            $nestedData[] = $row["motivo"];
            $nestedData[] = '<div class="dropdown dropdown-inline">
                <button type="button" class="btn btn-clean btn-icon btn-sm btn-icon-md" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="flaticon-more"></i>
                </button>
                <div class="dropdown-menu dropdown-menu-right" style="">
                    <a class="dropdown-item" href="'.$baseUrl.'/cita/create?pid='.$row["id_paciente"].'"><i class="la la-plus mt-2"></i> Agregar Cita</a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item mc-s" href="javascript:void(0);" onclick="marcarCompletoT('.$row["id"].');"><i class="la la-check-circle mt-2"></i> Marcar como Completado</a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item mp-s" href="javascript:void(0);" onclick="marcarPerdidoT('.$row["id"].');"><i class="la la-trash mt-2"></i> Marcar como Perdido</a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item ver-s" href="javascript:void(0);" onclick="verSeguimiento('.$row["id"].');"><i class="la la-eye mt-2"></i> Ver Seguimiento</a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item" href="'.Url::to(['paciente/view', 'id'=>$row["id_paciente"]]).'"><i class="la la-user mt-2"></i> Ver Paciente</a>
                </div>
            </div>';
            $data[] = $nestedData;
        }
        $json_data = [
            "draw" => intval($requestData['draw']), 
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data   // seguimientos
        ];
        return $json_data;
        
    }
    
    
    /**
     * 
     * @param app\models\Usuario $usuario
     * @return Array
     */
    private function obtenerSeguimientos($usuario){
        $qSeguimientos  = Seguimiento::find()
            ->where(['id_suscripcion' => $usuario->suscripcion->id])
            ->andWhere(['<>', 'estado', Seguimiento::COMPLETADO])
            ->andWhere(['<>', 'estado', Seguimiento::PERDIDO]);
        if( $usuario->suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA ){
            $qSeguimientos->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id ]);
        }
        $seguimientos = $qSeguimientos->orderBy(['fecha_seguimiento'=> \SORT_ASC])->all();
        $now = date('Y-m-d');
        $result = [];
        foreach($seguimientos as $seguimiento){
            $fecha = $seguimiento->fecha_seguimiento.' '. substr($seguimiento->hora_seguimiento,0,5);
            $result[] = [
                    'segId'          => $seguimiento->id,
                    'pacienteId'     => $seguimiento->paciente->id,
                    'pacienteNombre' => $seguimiento->paciente->nombreCompleto,
                    'pacienteCodigo' => $seguimiento->paciente->codigo != null ? $seguimiento->paciente->codigo : 'No definido',
                    'estadoCita'     => $seguimiento->estado_cita != null ? $seguimiento->estado_cita : 'No definido',
                    'segMotivo'      => $seguimiento->motivo,
                    'segFecha'       => $fecha,
                    'segInteraccion' => $seguimiento->interaccion,
                    'segOrigen'      => $seguimiento->origen,
                    'segClass'       => \strtotime($now) > \strtotime($seguimiento->fechaDB) ? 'no-valid' 
                                            : (\strtotime($now) == \strtotime($seguimiento->fechaDB) ? 'now' : '')
                ];
        }
        return $result;
    }
    
    public function actionSeguimientoPaciente(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        if(Yii::$app->request->isAjax && isset($post['id_paciente'])){
            $idPaciente = $post['id_paciente'];
            $qSeguimientos  = Seguimiento::find()
                ->where(['id_suscripcion' => $usuario->suscripcion->id])
                ->andWhere(['id_paciente'=>$idPaciente])    
                ->andWhere(['<>', 'estado', Seguimiento::COMPLETADO])
                ->andWhere(['<>', 'estado', Seguimiento::PERDIDO]);
            if( $usuario->suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA ){
                $qSeguimientos->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id ]);
            }
            $seguimientos = $qSeguimientos->orderBy(['fecha_seguimiento'=> \SORT_DESC])->all();
            $result = [];
            $paciente = null;
            $citaProx = null;
            foreach($seguimientos as $seguimiento){
                $fecha = $seguimiento->fecha_seguimiento.' '. substr($seguimiento->hora_seguimiento,0,5);
                $paciente = $seguimiento->paciente->nombreCompleto;
                $citaProx = $seguimiento->paciente->citaProxima;  
                $result[] = [
                    'id'          => $seguimiento->id,
                    'paciente_id' => $seguimiento->paciente->id,
                    'motivo'      => $seguimiento->motivo,
                    'fecha'       => $fecha
                ];
            }
            return ['Correcto'=>true,'Seguimientos'=>$result, 'Paciente'=>$paciente, 'CitaProxima'=>$citaProx];
        }
    }

    /**
     * Displays a single Seguimiento model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $this->layout = false;
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($id);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(['seguimiento/index']);
        }
        $interaccion = $model->interaccionSeguimiento;
        $bitacora = $model->bitacoraSeguimiento;
    return ['Correcto'=>true,'Paciente'=>['id'=>$model->paciente->id,'nombreCompleto'=>$model->paciente->nombreCompleto],'viewForm' =>$this->renderPartial('_detalle', ['model' => $model,'interaccion'=>$interaccion]), 'Bitacora'=>$bitacora, 'fecha'=>$model->fecha_seguimiento];
    }

    /**
     * Creates a new Seguimiento model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $now = date('Y-m-d');
        Yii::$app->response->format = Response::FORMAT_JSON;
        $this->layout = false;
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        $model = new Seguimiento();
        $nombrePaciente = null;
        $codigo = null;
        if( $usuario->suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA ){
            $model->id_clinica = SesionUtils::ClinicaSeleccionada()->id;
        }
        if(Yii::$app->request->isAjax && isset($post['idC'])){
            $cita = Cita::findOne(['id'=>$post['idC']]);
            $nombrePaciente = $cita->paciente->nombreCompleto;
            $codigo = $cita->paciente->codigo;
            $model->id_paciente = $cita->paciente->id;
            $model->motivo = $cita->estado == Cita::CANCELADA ? 'Cancelación del paciente '.$cita->paciente->nombreCompleto.' a su cita del '.$cita->fecha 
                    : 'Inasistencia del paciente '.$cita->paciente->nombreCompleto.' a su cita del '.$cita->fecha;
            $model->fecha_seguimiento = date('d/m/Y', strtotime($now.'+15 days'));
            $model->id_cita_origen = $cita->id;
            $model->interaccion = '¡Llamarle al paciente!';
            $model->hora_seguimiento = SesionUtils::getHoraEntradaClinica($usuario);
        }
        if(Yii::$app->request->isAjax && isset($post['idP'])){
            $paciente = Paciente::findOne(['id'=>$post['idP']]);
            $nombrePaciente = $paciente->nombreCompleto;
            $model->id_paciente = $paciente->id;
            $model->fecha_seguimiento = date('d/m/Y', strtotime($now.'+15 days'));
            $model->interaccion = '¡Llamarle al paciente!';
        }
        if(Yii::$app->request->isAjax && isset($post['paciente_id'])){
            $idSuscripcion = $usuario->tipo == Usuario::ASISTENTE ? SesionUtils::ClinicaSeleccionada()->id : $usuario->suscripcion->id; 
            $model->id_suscripcion = $idSuscripcion;
            $model->id_paciente = $post['paciente_id'];
            $model->fecha_incidencia = date('Y-m-d H:i:s');
            $model->motivo = $post['motivo'];
            $model->fecha_seguimiento = $post['fecha_seguimiento'];
            $model->hora_seguimiento  = $post['hora_seguimiento'];
            $model->interaccion = $post['interaccion'];
            $model->id_usuario = $usuario->tipo == Usuario::ASISTENTE ? $usuario->usuarioSuscripcion->id_usuario : $usuario->suscripcion->usuario->id;
            $model->estado = Seguimiento::PENDIENTE;
            $model->origen = 1;
            if($model->save()){
                $this->guardarBitacoraSeguimiento($model, $usuario);
                return ['Correcto'=>true];
            } else {
              print_r($model->getErrors());
            } 
        }
        $viewForm = $this->renderPartial('_form', ['model' => $model]);
        return ['Correcto'=>true,'viewForm' =>$viewForm, 'paciente'=>$nombrePaciente];
    }
    
    
    /**
     * Updates an existing Seguimiento model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $this->layout = false;
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        if(Yii::$app->request->isAjax){
            $id =  $post['id'];
            $model = $this->findModel($id);
            $interaccionDB = $model->interaccion;
            $fechaSegDB = $model->fechaDB;
            if($model->id_suscripcion != $usuario->suscripcion->id){
                return $this->redirect(['seguimiento/index']);
            }
            $model->fecha_seguimiento = $post['fecha'];
            $model->hora_seguimiento  = $post['hora'];
            $model->interaccion = $post['acercamiento'];
            $model->id_usuario = $usuario->tipo == Usuario::ASISTENTE ? $usuario->usuarioSuscripcion->id_usuario : $usuario->suscripcion->usuario->id;
            $model->origen = 1;
            if($model->save()){
                $this->guardarBitacoraSeguimiento($model, $usuario);
                $acercamiento = $model->interaccionSeguimiento;
                $fecha = \DateTime::createFromFormat('Y-m-d', $model->fecha_seguimiento)->format('d/m/Y');
                $bitacora = $model->bitacoraSeguimiento;
                return ['Correcto'=>true, 'S'=>$model, 'fecha'=>$fecha, 'Acercamiento'=>$acercamiento, 'Bitacora'=>$bitacora];
            } else {
              print_r($model->getErrors());
            }
        }
        return ['Correcto'=>false];
    }
    
    public function actionComentario(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        if(Yii::$app->request->isAjax){
            $model = BitacoraSeguimiento::findOne(['id'=>$post['id']]);
            $fecha = $model->fechaIncidenciaDB;
            $model->fecha_incidencia = $fecha;
            $model->fecha_seguimiento = date('Y-m-d');
            $model->comentario = $post['comentario'];
            if($model->save()){
                $bitacora = $model->seguimiento->bitacoraSeguimiento;
                return ['Correcto'=>true,'C'=>$model, 'Bitacora'=>$bitacora];
            }
        }
        return ['Correcto'=>false];
    }
    
    public function actionMarcarCompletado(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $this->layout = false;
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        if(Yii::$app->request->isAjax){
            $id = $post['id'];
            $model = $this->findModel($id);
            $model->estado = Seguimiento::COMPLETADO;
            $model->save();
            return ['Correcto'=>true];
        }
        return ['Correcto'=>false];
    }
    /**
     * @param app\models\Seguimiento $seguimiento
     * @param app\models\Usuario  $usuario
     */
    private function guardarBitacoraSeguimiento($seguimiento,$usuario){
        $model = new BitacoraSeguimiento();
        $idUsuario = $usuario->tipo == Usuario::ASISTENTE ? $usuario->usuarioSuscripcion->id_usuario : $usuario->suscripcion->usuario->id;
        $model->id_seguimiento = $seguimiento->id;
        $model->fecha_incidencia = date('Y-m-d H:i:s');
        $model->fecha_seguimiento = $seguimiento->fecha_seguimiento;
        $model->id_usuario = $seguimiento->id_usuario;
        $model->interaccion = $seguimiento->interaccion;
        $model->save();
    }

    /**
     * Deletes an existing Seguimiento model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        if(Yii::$app->request->isAjax){
            $id =  $post['id'];
            $model = $this->findModel($id);
            if($model->id_suscripcion != $usuario->suscripcion->id){
                return $this->redirect(['seguimiento/index']);
            }
            $model->estado = Seguimiento::COMPLETADO;
            $model->save();
            return ['Correcto'=>true];
        }
    }
    
        public function actionPerdido()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        if(Yii::$app->request->isAjax){
            $id =  $post['id'];
            $model = $this->findModel($id);
            if($model->id_suscripcion != $usuario->suscripcion->id){
                return $this->redirect(['seguimiento/index']);
            }
            $model->estado = Seguimiento::PERDIDO; 
            $model->save();
            return ['Correcto'=>true];
        }
    }
    
    public function actionDeleteBitacoraItem(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        if(Yii::$app->request->isAjax){
            $id =  $post['id'];
            $model = BitacoraSeguimiento::findOne(['id'=>$id]);
            $model->delete();
            return ['Correcto'=>true];
        }
        return ['Correcto'=>false];
    }
    
    public function actionCompletarSeguimientosPaciente(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $idSuscripcion = $usuario->suscripcion->id;
        $post = Yii::$app->request->post();
        if(Yii::$app->request->isAjax){
            $idPaciente =  $post['id_paciente'];
            Seguimiento::updateAll(['estado'=>Seguimiento::COMPLETADO],['id_suscripcion'=>$idSuscripcion,'id_paciente'=>$idPaciente]);
            return ['Correcto'=>true];
        }
        return ['Correcto'=>false];
    }

    /**
     * Finds the Seguimiento model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Evento the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Seguimiento::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
    public function excludeFromSecurity(){
         return [
             'create',
             'citas-asistencia', 
             'seguimientos', 
             'delete-bitacora-item', 
             'seguimiento-paciente', 
             'completar-seguimientos-paciente'
             ];
    }
    
    public function beforeAction($action)
    {            
        if ($action->id == 'citas-asistencia' || $action->id == 'seguimientos' || $action->id == 'update' || $action->id == 'comentario' ) {
            $this->enableCsrfValidation = false;
        }

        return parent::beforeAction($action);
    }
    
    public function checkForSubscription() {
        return ['create','update','comentario'];
    }
}
