<?php
namespace app\controllers;

use Yii;
use yii\filters\VerbFilter;
use yii\web\Response;
use app\customs\BaseController;
use yii\db\Expression;
use app\models\Cita;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
class ReportesAdminController extends BaseController{
        //put your code here
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'datos-usuarios-activos' => ['post'],
                    'usuarios-inactivos' => ['post'],
                ],
            ],
        ];
    }
    
    public function actionIndex(){
        return $this->render('usuarios-activos');
    }
    
    public function actionDatosUsuariosActivos(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = \Yii::$app->request->post();
        $fecha_inicio = \DateTime::createFromFormat('d/m/Y', $post['fecha_inicio'])->format('Y-m-d');
        $fecha_fin = \DateTime::createFromFormat('d/m/Y', $post['fecha_fin'])->format('Y-m-d');
        $fechaI = date_create($fecha_inicio);
        $fechaL = date_create($fecha_fin);
        $diff = date_diff($fechaI, $fechaL);
        $nDias = ($diff->format('%y')*12*30) + ($diff->format('%m')*30) + $diff->format('%d') + 1;
        $count = floor($nDias/7);
        if($nDias%7 == 0){
            $count--;    
        }
        $fechaI_format = date_format($fechaI,"Y-m-d");
        $fechaF_format = date_format($fechaL,"Y-m-d");
        $rangos = [];
        $rangos[] = $fechaI_format;
        $fechaApoyo = $fechaI_format;
        for($i=1; $i<=$count; $i++){
            $fechaApoyo = date('Y-m-d', strtotime($fechaApoyo.'+6 days'));
            $rangos[] = $fechaApoyo;
            $fechaApoyo = date('Y-m-d', strtotime($fechaApoyo.'+1 days'));
            $rangos[] = $fechaApoyo;
        }
        $rangos[] = $fechaF_format;
        $datosGrafica = $this->datosGrafica($rangos);
        return ['Correcto'=>true,'DatosGrafica'=>$datosGrafica];
    }
    
    private function datosGrafica($rangos){
        $db = Cita::getDb();
        $k = count($rangos)/2;
        $l = 0;
        $j = 1;
        $labels = [];
        $conteo = [];
        for($i=1; $i <=$k; $i++){
            $sqlStr1 = 'SELECT COUNT(*) usuarios
                FROM usuario uu
                INNER JOIN suscripcion us ON us.id_usuario = uu.id
                WHERE (
                  SELECT COUNT(*) FROM cita c
                  INNER JOIN bitacora_cita bc ON bc.id_cita = c.id  
                  WHERE c.id_suscripcion = us.id AND c.id = bc.id_cita
                  AND (DATE(bc.fecha) BETWEEN DATE_ADD(\'' . $rangos[$l] . '\',INTERVAL -0 DAY) AND DATE_ADD(\'' . $rangos[$j] . '\',INTERVAL -0 DAY))    
                  AND bc.estado = 0  
                ) >= 5';
            $data = $db->createCommand($sqlStr1)->queryAll();
            foreach ($data as $val){
                $conteo[] = (int)$val['usuarios'];
            }
            $labels[] = \DateTime::createFromFormat('Y-m-d', $rangos[$l])->format('d/m/Y').' - '.\DateTime::createFromFormat('Y-m-d', $rangos[$j])->format('d/m/Y');
            $l = $l + 2;
            $j = $j + 2;
        }
        return ['Conteo' => $conteo,'Labels' => $labels];
    }
    
    public function actionUsuariosInactivos(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $fecha = filter_input(INPUT_POST, 'fecha');
        $data = $this->datosUsuariosInactivos($fecha);
        return ['Correcto'=>true, 'usuariosInactivos'=>$data];
    }
    
    private function datosUsuariosInactivos($fecha){
        $fechaInicio = \DateTime::createFromFormat('d/m/Y', $fecha)->format('Y-m-d');
        $fechaFin = date('Y-m-d', strtotime($fechaInicio.'+6 days'));
        $db = Cita::getDb();
        $sqlStr = 'SELECT us.id, uu.nombre_usuario usuario, p.nombre, p.apellidos, p.telefonos,
            (
                SELECT COUNT(*) FROM cita c
                INNER JOIN bitacora_cita bc ON bc.id_cita = c.id  
                WHERE c.id_suscripcion = us.id AND c.id = bc.id_cita
                AND (DATE(bc.fecha) BETWEEN DATE_ADD(\'' . $fechaInicio . '\',INTERVAL -0 DAY) AND DATE_ADD(\'' . $fechaFin . '\',INTERVAL -0 DAY))  
                AND bc.estado = 0  
            )Ncitas
                    FROM usuario uu
                    INNER JOIN suscripcion us ON us.id_usuario = uu.id
                    INNER JOIN perfil p ON p.id = uu.id
                    WHERE (
                      SELECT COUNT(*) FROM cita c
                      INNER JOIN bitacora_cita bc ON bc.id_cita = c.id  
                      WHERE c.id_suscripcion = us.id AND c.id = bc.id_cita
                      AND (DATE(bc.fecha) BETWEEN DATE_ADD(\'' . $fechaInicio . '\',INTERVAL -0 DAY) AND DATE_ADD(\'' . $fechaFin . '\',INTERVAL -0 DAY))  
                      AND bc.estado = 0  
                    ) < 5';        
            $data = $db->createCommand($sqlStr)->queryAll();
            $res = [];
            foreach ($data as $val){
                $res[] = [
                    'id'=>$val['id'],
                    'usuario'=>$val['usuario'],
                    'nombre'=>$val['nombre'],
                    'apellido'=>$val['apellidos'],
                    'telefonos'=>$val['telefonos'],
                    'Ncitas'=>$val['Ncitas'],
                    'url'=>Url::toRoute(['suscripcion/view','id' =>$val['id']]),
                ]; 
            }
        return $res;    
    }
    
    public function actionCitasUsuarios(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = \Yii::$app->request->post();
        $fecha_inicio = \DateTime::createFromFormat('d/m/Y', $post['fecha_inicio'])->format('Y-m-d');
        $fecha_fin = \DateTime::createFromFormat('d/m/Y', $post['fecha_fin'])->format('Y-m-d');
        $fechaI = date_create($fecha_inicio);
        $fechaL = date_create($fecha_fin);
        $diff = date_diff($fechaI, $fechaL);
        $nDias = ($diff->format('%y')*12*30) + ($diff->format('%m')*30) + $diff->format('%d') + 1;
        $count = floor($nDias/7);
        if($nDias%7 == 0)$count--;    
        $fechaI_format = date_format($fechaI,"Y-m-d");
        $fechaF_format = date_format($fechaL,"Y-m-d");
        $rangos = [];
        $rangos[] = $fechaI_format;
        $fechaApoyo = $fechaI_format;
        for($i=1; $i<=$count; $i++){
            $fechaApoyo = date('Y-m-d', strtotime($fechaApoyo.'+6 days'));
            $rangos[] = $fechaApoyo;
            $fechaApoyo = date('Y-m-d', strtotime($fechaApoyo.'+1 days'));
            $rangos[] = $fechaApoyo;
        }
        $rangos[] = $fechaF_format;
        $datosGrafica = $this->datosGraficaCitas($rangos);
        return ['Correcto'=>true,'DatosGrafica'=>$datosGrafica];
    }
    
    private function datosGraficaCitas($rangos){
        $db = Cita::getDb();
        $k = count($rangos)/2;
        $l = 0;
        $j = 1;
        $labels = [];
        $conteo = [];
        for($i=1; $i <=$k; $i++){
            $sqlStr1 = '
                  SELECT COUNT(*) Ncitas FROM cita c
                  INNER JOIN bitacora_cita bc ON bc.id_cita = c.id  
                  AND (DATE(bc.fecha) BETWEEN DATE_ADD(\'' . $rangos[$l] . '\',INTERVAL -0 DAY) AND DATE_ADD(\'' . $rangos[$j] . '\',INTERVAL -0 DAY))    
                  AND bc.estado = 0';
            $data = $db->createCommand($sqlStr1)->queryAll();
            foreach ($data as $val){
                $conteo[] = (int)$val['Ncitas'];
            }
            $labels[] = \DateTime::createFromFormat('Y-m-d', $rangos[$l])->format('d/m/Y').' - '.\DateTime::createFromFormat('Y-m-d', $rangos[$j])->format('d/m/Y');
            $l = $l + 2;
            $j = $j + 2;
        }
        return ['Conteo' => $conteo,'Labels' => $labels];
    }
    
    public function excludeFromSecurity() {
        return ['datos-usuarios-activos', 'usuarios-inactivos', 'citas-usuarios'];
    }
    
    public function beforeAction($action)
    {            
        if ($action->id == 'datos-usuarios-activos' || $action->id == 'usuarios-inactivos' || $action->id == 'citas-usuarios') {
            $this->enableCsrfValidation = false;
        }
        return parent::beforeAction($action);
    }
    
}
