<?php

namespace app\controllers;

use Yii;
use app\models\PlantillaDiagnostico;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\Response;

/**
 * ProcedimientoController implements the CRUD actions for PlantillaDiagnostico model.
 */
class PlantillaDiagnosticoController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Procedimiento models.
     * @return mixed
     */
    public function actionIndex()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $requestData = $_REQUEST;
        $db = PlantillaDiagnostico::getDb();
        $columns = [
            0 => 'titulo',
            1 => 'cuerpo'
        ];
        $sql = "SELECT * FROM plantilla_diagnostico "
                . "WHERE id_suscripcion = ".$usuario->suscripcion->id;
        $data = $db->createCommand($sql)->queryAll();
        $totalData = count($data);
        $totalFiltered = $totalData;
        if(!empty($requestData['search']['value'])){
            $sql.=" AND ( titulo LIKE '" . $requestData['search']['value'] . "%' ";
            $sql.=" OR titulo LIKE '%" . $requestData['search']['value'] . "%' ) ";
        }
        $data = $db->createCommand($sql)->queryAll();
        $totalFiltered = count($data);
        $sql.=" ORDER BY " . $columns[$requestData['order'][0]['column']] . "   " . $requestData['order'][0]['dir'] . "  LIMIT " . $requestData['start'] . " ," . 
        $requestData['length'] . "   ";
        $result = $db->createCommand($sql)->queryAll();
        $data = [];
        foreach($result as $key => $row){
             $nestedData = [];
             $nestedData[] = $row['id'];
             $nestedData[] = $row['titulo'];
             $nestedData[] = substr($row['cuerpo'],0,30).'...';
             $nestedData[] = '<div class="dropdown dropdown-inline">
                    <button type="button" class="btn btn-clean btn-icon btn-sm btn-icon-md" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="flaticon-more"></i>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right" style="">
                        <a class="dropdown-item mc-s" href="javascript:void(0);" onclick="verPlantilla('.$row["id"].');"><i class="la la-eye mt-2"></i>Ver</a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item mp-s" href="javascript:void(0);" onclick="actualizarPlantilla('.$row["id"].');"><i class="la la-edit mt-2"></i>Actualizar</a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item mp-s" href="javascript:void(0);" onclick="eliminarPlantilla('.$row["id"].');"><i class="la la-trash mt-2"></i>Eliminar</a>
                    </div>
                </div>';
             $data[] = $nestedData;
        }
        $json_data = [
            "draw" => intval($requestData['draw']), 
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data   //plantillas
        ];
        return $json_data;
    }
    


    /**
     * Displays a single Procedimiento model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($id);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }
        return ['Correcto'=>true, 'id' =>$model->id, 'titulo'=>$model->titulo, 'cuerpo'=>$model->cuerpo, 'cuerpoFormat'=>$model->formatoCuerpo];
    }

    /**
     * Creates a new Procedimiento model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $model = new PlantillaDiagnostico();
        $usuario = Yii::$app->user->identity;
        $model->id_suscripcion = $usuario->suscripcion->id;
        $post = Yii::$app->request->post();
        if(Yii::$app->request->isAjax){
            $model->titulo = $post['titulo'];
            $model->cuerpo = $post['cuerpo'];
            if($model->save()){
                return ['Correcto'=>true, 'model' => $model];
            }
            return ['Correcto'=>false];
        }

    }

    /**
     * Updates an existing PlantillaDiagnostico model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        if(Yii::$app->request->isAjax){
            $model = $this->findModel($post['id']);
            if($model->id_suscripcion != $usuario->suscripcion->id){
                return $this->redirect(["site/forbidden"], 403);
            }
            $model->titulo = $post['titulo'];
            $model->cuerpo = $post['cuerpo'];
            if($model->save()){
                return ['Correcto'=>true, 'model' => $model, 'cuerpoFormat'=>$model->formatoCuerpo ];
            }
            return ['Correcto'=>false];
        }
        
    }

    /**
     * Deletes an existing PlantillaDiagnostico model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($post['id']);
        $model->delete();
        return ['Correcto'=>true];
    }
    

    /**
     * Finds the PlantillaDiagnostico model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return PlantillaDiagnostico the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = PlantillaDiagnostico::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
        public function excludeFromSecurity(){
         return [
             'index',
             'create',
             'view',
             'update',
             'delete'
             ];
    }
    
    public function beforeAction($action)
    {            
        if ($action->id == 'index' || $action->id == 'create' || $action->id == 'update' || $action->id == 'delete') {
            $this->enableCsrfValidation = false;
        }

        return parent::beforeAction($action);
    }
    
}
