<?php

namespace app\controllers;

use Yii;
use app\models\ListaEspera;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\Response;
use yii\helpers\Url;

/**
 * EventoController implements the CRUD actions for ListaEspera model.
 */
class ListaEsperaController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all ListaEspera models.
     * @return mixed
     */
    public function actionIndex()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $data = ListaEspera::find()
                ->where(['id_suscripcion'=>$usuario->suscripcion->id])
                ->andWhere(['estado'=> ListaEspera::PENDIENTE])
                ->orderBy(['fecha_creacion' => SORT_ASC])
                ->all();
        $res = [];
        foreach($data as $ls){
            $res[] = [
                'id' => $ls->id,
                'paciente' => $ls->paciente,
                'comentario' => $ls->comentario,
                'fecha_creacion' => $ls->fecha_creacion,
                'url_paciente' => Url::to(['paciente/view','id'=>$ls->id_paciente]),
                'url_agregar_cita' => Url::to(['cita/create','pid'=>$ls->id_paciente, 'idLs'=>$ls->id]),
            ];
        }
        
        return ['Correcto'=>true, 'Lista'=>$res];
    }

    

    /**
     * Displays a single ListaEspera model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($id);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(['calendario/index']);
        }
        return ['Correcto'=>true, 'model'=>[
            'id' => $model->id, 
            'comentario' => $model->comentario, 
            'paciente' => $model->paciente]];
    }

    /**
     * Creates a new ListaEspera model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        $model = new ListaEspera();
        if(Yii::$app->request->isAjax){
            $model->id_suscripcion = $usuario->suscripcion->id;
            $model->id_paciente = $post['id_paciente'];
            $model->comentario = $post['comentario'];
            $model->fecha_creacion = date('Y-m-d H:i:s');
            $model->estado = ListaEspera::PENDIENTE;
            if($model->save()){
                return ['Correcto'=>true];
            } else {
              print_r($model->getErrors());
              return ['Correcto'=>false];
            } 
        }
    }
    

    

    /**
     * Updates an existing ListaEspera model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        $model = $this->findModel($id);
        if(Yii::$app->request->isAjax){
            $model->id_paciente = $post['id_paciente'];
            $model->comentario = $post['comentario'];
            if($model->save()){
                return ['Correcto'=>true];
            } else {
              print_r($model->getErrors());
              return ['Correcto'=>false];
            } 
        }
    }


    public function actionDelete()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        if(Yii::$app->request->isAjax){
            $model = $this->findModel($post['id']);
            if($model->id_suscripcion != $usuario->suscripcion->id){
                return ['Correcto'=>false, 'msg'=>'No se puede eliminar. No pertenece a sus suscripción.'];
            }
            $model->estado = ListaEspera::COMPLETADO;
            $model->save();
            return ['Correcto'=>true];
        }
    }
    


    /**
     * Finds the ListaEspera model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Evento the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = ListaEspera::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
    public function excludeFromSecurity(){
         return [ 'index', 'create', 'update', 'delete' ];
    }
    
    public function beforeAction($action)
    {            
        if ($action->id == 'create' || $action->id == 'update' ) {
            $this->enableCsrfValidation = false;
        }

        return parent::beforeAction($action);
    }
    
    public function checkForSubscription() {
        return ['create','update'];
    }
}
