<?php

namespace app\controllers;

use Yii;
use app\models\HorarioMedico;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Usuario;
use app\models\Clinica;
use yii\helpers\ArrayHelper;
use app\customs\SesionUtils;

/**
 * HorarioController implements the CRUD actions for HorarioMedico model.
 */
class HorarioController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all HorarioMedico models.
     * @return mixed
     */
    public function actionIndex()
    {           
        $model = new HorarioMedico();
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $id_suscripcion = $suscripcion->id;
        $post = Yii::$app->request->post();
        if (Yii::$app->request->post() ) {
            $id_clinica = $post['id_clinica'];
            HorarioMedico::deleteAll(['id_suscripcion'=>$id_suscripcion, 'id_clinica'=>$id_clinica]);
            if(isset($post['dia']) && isset($post['hora-inicio']) && isset($post['hora-fin']) ){
                $dias = [];
                $strdias = explode(',',$post['dia']);//convertir el string de dias en array
                asort($strdias);//ordenar asc
                foreach ($strdias as $dia){
                    if($dia != ''){//eliminar conjuntos vacios
                        $dias[] = $dia;//nuevo array ordenado
                    }
                }
                $horaInicio = $post['hora-inicio'];
                $horaFin = $post['hora-fin'];
                //return var_dump(['A'=>$id_clinica, 'D'=>$dias, 'HI'=>$horaInicio, 'HF'=>$horaFin]);
                //return var_dump(['dias'=>$dais]);
                $this->guardarHorario($dias,$horaInicio,$horaFin,$id_suscripcion,$id_clinica);
            }
        }
        
        $where = $suscripcion->tipo == \app\models\Suscripcion::TIPO_INDIVIDUAL && $usuario->tipo == Usuario::DOCTOR 
                ? ["id_suscripcion" => $id_suscripcion]
                : ["id_suscripcion" => $id_suscripcion,'id' => SesionUtils::ClinicaSeleccionada()->id];
        $clinicas = Clinica::find()->where($where)->all();
        return $this->render('index',[
            'clinicas'=> $clinicas,
            'dropClinicas' => ArrayHelper::map($clinicas, 'id', 'nombre'),
            'model' =>$model,
        ]);
    }
    
     /**
     * Buscar los horarios por el id de la clinica.
     * @param integer $id_clinica
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionCargarHorarios($id_clinica){
        $this->layout = false;
        $clinica = Clinica::findOne($id_clinica);
        return $this->render('_formModal',['clinica' => $clinica, 'id_clinica' =>$id_clinica ]);
    }

    /**
     * Displays a single HorarioMedico model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($id);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }
        
        return $this->render('view', [
            'model' => $model,
        ]);
    }

    /**
     * Creates a new HorarioMedico model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new HorarioMedico();
        $usuario = Yii::$app->user->identity;
        $idSuscripcion = $usuario->suscripcion->id;
        $model->id_suscripcion = $idSuscripcion;
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'El horario se ha guardado exitosamente');
            return $this->redirect(['index']);
        }
        $clinicas = $usuario->tipo == Usuario::DOCTOR ? Clinica::find()->where(['id_suscripcion' => $idSuscripcion])->all() : [];
        return $this->render('create', [
            'model' => $model,
            'clinicas' => ArrayHelper::map($clinicas, 'id', 'nombre')
        ]);
    }
    
     /**
     * Creates a new HorarioMedico model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    private function guardarHorario($dias,$horaInicio,$horaFin,$id_suscripcion,$id_clinica)
    {
        $contHoraI = 0;
        $contHoraF = 0;
        $j = count($dias);
        for ($i = 0; $i < $j; $i++) {
            $model = new HorarioMedico();
            $model->id_suscripcion = $id_suscripcion;
            $model->dia = $dias[$i];
            $model->hora_inicio = $horaInicio[$contHoraI];
            $model->hora_fin = $horaFin[$contHoraF];
            $model->id_clinica = $id_clinica;
            $model->save();
            unset($model);//vacia el model para poder asignar nuevos valores
            $contHoraI++;
            $contHoraF++;
        }
        Yii::$app->session->setFlash('success', 'El horario se ha guardado exitosamente');
        return $this->redirect(['index']);
    }

    /**
     * Updates an existing HorarioMedico model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $usuario = Yii::$app->user->identity;
        if ($model->load(Yii::$app->request->post())) {
            if($model->save()){
                Yii::$app->session->setFlas('success', 'Se ha actualizado el horario exitosamente');
                return $this->redirect(['view', 'id' => $model->id]);
            }
        }
        
        $idSuscripcion = $usuario->suscripcion->id;
        if($model->id_suscripcion != $idSuscripcion){
            return $this->redirect(["site/forbidden"], 403);
        }
        $clinicas = $usuario->tipo == Usuario::DOCTOR ? Clinica::find()->where(['id_suscripcion' => $idSuscripcion])->all() : [];
        return $this->render('update', [
                'model' => $model,
                'clinicas' => ArrayHelper::map($clinicas, 'id', 'nombre')
            ]);
        
    }
    
    /**
     * Deletes an existing HorarioMedico model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete()
    {
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        if(isset($post['horario_id'])){
            $horarios = $post['horario_id'];
            $contHorario = count($horarios);
            foreach ($horarios as $id){
                $model = $this->findModel($id);
                if($model->id_suscripcion != $usuario->suscripcion->id){
                    return $this->redirect(["site/forbidden"], 403);
                } else {
                    $model->delete();
                }
            }
            if($contHorario > 1){
                Yii::$app->session->setFlash('danger', 'Se han eliminado los horarios');
            }else{
                Yii::$app->session->setFlash('danger', 'Se ha eliminado el horario');
            }
        } else {
            Yii::$app->session->setFlash('warning', 'Debe seleccionar al menos un horario');
        }
        return $this->redirect(['index']);
    }

    /**
     * Finds the HorarioMedico model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return HorarioMedico the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = HorarioMedico::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function excludeFromSecurity() {
        return ['cargar-horarios'];
    }
}
