<?php

namespace app\controllers;

use Yii;
use yii\web\Response;
use app\models\Paciente;
use app\models\DocumentoPaciente;

class DocumentoPacienteController extends \yii\web\Controller
{
    public function actionCreate()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $idSuscripcion = Yii::$app->user->identity->suscripcion->id;
        $post = Yii::$app->request->post();
        $fecha = \DateTime::createFromFormat('d/m/Y', $post['fecha'])->format('Y-m-d');
        $paciente = Paciente::find()->where(['id' => $post['id_paciente'], 'id_suscripcion' =>$idSuscripcion ])->one();
        $input = 'documentos-paciente'; // the input name for the fileinput plugin
        if ( empty($_FILES[$input]) || $paciente == null || $paciente->id_suscripcion != $idSuscripcion) { return []; }
        $preview = $config = $errors = [];
        $total = \count($_FILES[$input]['name']); // multiple files
        for ($i = 0; $i < $total; $i++) {
            $tmpFilePath = $_FILES[$input]['tmp_name'][$i]; // ruta temporal del archivo
            $randomStr = Yii::$app->security->generateRandomString(5);
            list($name, $ext) = DocumentoPaciente::nombreExtDocumento($_FILES[$input]['name'][$i]) ; // nombre y extension
            $fileName = $name . $randomStr . ".{$ext}";
            $path = DocumentoPaciente::getUrlDocumento($ext); // to upload file
            $newPath = DocumentoPaciente::getSrcDocumento($ext); // to get file
            $fileSize = $_FILES[$input]['size'][$i]; // size of file
            //Make sure we have a file path
            if ($tmpFilePath != ""){
                //Setup our new file path
                $newFilePath = $path . $fileName;
                $newFileUrl = DocumentoPaciente::getMinPreview($newPath.$fileName,$ext);
                //Upload the file into the new path
                if(\move_uploaded_file($tmpFilePath, $newFilePath)) {
                    $fileId = $fileName . $i; // some unique key to identify the file
                    $preview[] = $newFileUrl;
                    $config[] = $this->confResponseFormat($fileId, $fileName, $fileSize, $newFileUrl);
                    $this->guardarDocumentoPaciente($paciente->id,$fileName,$ext,$fecha);
                } else {
                    $errors[] = $fileName;
                }
            } else {
                $errors[] = $fileName;
            }
        }
        $out = ['initialPreview' => $preview, 'initialPreviewConfig' => $config, 'initialPreviewAsData' => true];
        if (!empty($errors)) {
            $img = \count($errors) === 1 ? 'archivo "' . $errors[0]  . '" ' : 'archivos: "' . \implode('", "', $errors) . '" ';
            $out['error'] = 'No pudimos subir el ' . $img . 'ahora. Intente nuevamnete.';
        }
        return $out;
    }
    
    private function confResponseFormat($fileId,$fileName,$fileSize,$newFileUrl)
    {
        return [
            'key' => $fileId,
            'caption' => $fileName,
            'size' => $fileSize,
            'downloadUrl' => $newFileUrl, // the url to download the file
            'url' => 'http://localhost/delete.php', // server api to delete the file based on key
        ];
    }
    
    private function guardarDocumentoPaciente($id,$nameDoc,$ext,$fecha)
    {
        $model = new DocumentoPaciente();
        $model->scenario = DocumentoPaciente::AJAX_METHOD;
        $model->id_paciente = $id;
        $model->documento_src_nombre = $nameDoc;
        $model->tipo = DocumentoPaciente::getTipoDocumento($ext);
        $model->fecha = $fecha;
        $model->save();
    }
    
    /**
     * Adjuntos de cita Ajax
     * @param int $id
     * @return array 
     */
    public function actionDocumentosPaciente($id_paciente,$fecha){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $documentos= [];
        $model = DocumentoPaciente::find()->where(['id_paciente'=>$id_paciente, 'fecha'=>$fecha])->all();
        foreach($model as $doc){
            $documentos[] = [
                'id' => $doc->id,
                '_nombre_' => $doc->documento_src_nombre,
                'descripcion'=> $doc->documentoDescripcion,
                'urlDocumento' => $doc->rutaParaVista,
                'tipo'=> $doc->tipo
            ];
        }
        return ['Correcto'=>true, 'documentos'=>$documentos];
    }
    
    public function actionActualizarDescripcion(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $id = filter_input(INPUT_POST, 'id');
        $descripcion = filter_input(INPUT_POST, 'title');
        $model = $this->findModel($id);
        $model->descripcion = $descripcion;
        if($model->save()){
            return [
                'Correcto' => true,
                'documento' => [
                    'id' => $model->id, 
                    'src' => $model->rutaParaVista, 
                    'srcname' => $model->rutaParaVista, 
                    'tipo' => $model->tipo, 
                    'descripcion' => $model->descripcion, 
                    '_nombre_' => $model->documento_src_nombre
                ]
            ];
        }
    }
    
    
    public function actionDelete(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $id = filter_input(INPUT_POST, 'id');
        $model = $this->findModel($id);
        $file = $model->documento_src_nombre;
        $path = DocumentoPaciente::getRutaTipo($model->tipo);
        unlink(strval(Yii::$app->basePath.'/web/'.$path.$file)); 
        $model->delete();
        return ['Correcto'=>true];
    }
    
    
    
    /**
     * Finds the Adjunto model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Adjunto the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    private function findModel($id){
        if(($model = DocumentoPaciente::findOne($id) )!= null){
            return $model;
        }
        throw new NotFoundHttpException('The requested page does not exist.');
    }
    

}
