<?php

namespace app\controllers;

use Yii;
use yii\helpers\Url;
use yii\web\Response;
use yii\db\Expression;
use yii\filters\VerbFilter;
use app\customs\BaseController;
use app\models\ComentarioSuscripcion;

/**
 * ComentarioSuscripcionController implements the CRUD actions for ComentarioSuscripcion model.
 */
class ComentarioSuscripcionController extends BaseController
{
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'create' => ['POST'],
                    'index' => ['GET'],
                ],
            ],
        ];
    }
    
    public function actionIndex( $fecha ){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $fechaFormat = \DateTime::createFromFormat('d/m/Y', $fecha)->format('Y-m-d');
        $qrtComentarios = ComentarioSuscripcion::find()
                ->where(['date(fecha)' => new Expression('date(\'' . $fechaFormat . '\')')])
                ->all();
        $comentarios = [];
        foreach ( $qrtComentarios as $coment ){
            $perfil = $coment->suscripcion->usuario->perfil;
            $comentarios[] = [
                'id' => $coment->id,
                'titulo' => $perfil->nombreCompleto,
                'comentario' => $coment->comentario,
                'url' => Url::to(['suscripcion/view', 'id'=>$coment->id_suscripcion ])
            ];
        }
        return ['Correcto' => true, 'Comentarios'=>$comentarios];
    }
    
    public function actionCreate(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        $model = new ComentarioSuscripcion();
        $model->id_suscripcion = $usuario->suscripcion->id;
        $model->fecha = date('Y-m-d H:i:s');
        $model->comentario = $post['comentario'];
        if( $model->save() ){
            return ['Correcto'=> true];
        } else {
            return ['Correcto'=> false];
        }
    }
    
    public function beforeAction($action) {
        if( $action->id == 'create'){
            $this->enableCsrfValidation = false;
        }
        return parent::beforeAction($action);
    }
    
    public function excludeFromSecurity() {
        return ['index','create'];
    }
}