<?php

namespace app\commands;

use yii\console\Controller;
use yii\console\ExitCode;
use app\models\repositories\CitaRepository;
use app\models\Cita;
use ClickSend\Configuration;
use ClickSend\Api\SMSApi;
use GuzzleHttp\Client;
use ClickSend\Model\SmsMessage;
use ClickSend\Model\SmsMessageCollection;
use app\models\BitacoraCitaMensaje;
use app\models\repositories\UrlCitaRepository;
use app\models\cron\CronLog;
use app\customs\Utils;
use app\models\UrlCita;
use app\customs\SesionUtils;
use app\models\Suscripcion;

class RecordatorioController extends Controller
{
    private static $params = [
        'class' => 'Swift_SmtpTransport',
        'host' => 'mail.oliviahealth.com', 
        'username' => 'info@oliviahealth.com',
        'password' => 'rrtm54R?dBZS',
        'port' => '25',
    ];

    public function actionEmail()
    {
        $recSub = []; 
        $confRecSub = []; 
        $citas = CitaRepository::citasNotificacion(CitaRepository::EMAIL);
        \Yii::$app->mailer->setTransport( self::$params );
            foreach($citas as $cita){
                $ids = $cita->id_suscripcion;
                if(!array_key_exists("sub_$ids", $recSub)){ 
                    $recSub["sub_"."$ids"] = CitaRepository::recordatoriosCita($ids, CitaRepository::EMAIL);
                }
                if(!array_key_exists("sub_$ids", $confRecSub)){
                    $confRecSub["sub_"."$ids"] = explode('|',SesionUtils::getValorLlave('tiempos_de_comunicacion', $ids)->valor);                    
                }
                $llaveReprogramacion = SesionUtils::getValorLlave('permitir_reprogramacion_paciente', $ids);
                $confComunicacion = explode('|',SesionUtils::getValorLlave('comunicacion_paciente', $ids)->valor);
                $linkTeleconsulta = ($cita->suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL)
                    ? SesionUtils::getValorLlave('link_teleconsulta', $cita->id_suscripcion)->valor
                    : SesionUtils::getValorLlave('link_teleconsulta', $cita->id_suscripcion, $cita->id_clinica)->valor;
                $articulo = SesionUtils::armarArticulo($ids, false, false);
                if(in_array('correo', $confComunicacion) && $cita->paciente->email_encargado_sec != null){
                    $this->recordatorioEmailEncargado($cita, $articulo, $linkTeleconsulta);
                }
                if(in_array('correo', $confComunicacion) && $cita->paciente->email != null){
                    if($this->tiemposComunicacion($recSub["sub_$ids"],$confRecSub["sub_$ids"])){
                        $urlCita = UrlCitaRepository::ObtenerUrlCitaPorCita($cita->id);
                        \yii::$app->mailer->compose('recordatorio-cita',[
                            'model' => $cita,
                            'urlCita' => $urlCita, 
                            'llave' => $llaveReprogramacion, 
                            'articulo' => $articulo,
                            'linkTeleconsulta' => $linkTeleconsulta,
                            'omitirClinica' => $cita->suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA
                        ])
                        ->setFrom(['citas@oliviahealth.com' => 'Olivia Health'])
                        ->setTo($cita->paciente->email)
                        ->setSubject("Recordatorio de " . $articulo)
                        ->send();
                        $this->guardarBitacora($cita->id, $cita->estado, true, false, BitacoraCitaMensaje::ES_RECORDATORIO);    
                    }
                }
                
            }
        $this->GuardarCronLog('recordatorio/email', count($citas));    
        return ExitCode::OK;

    }
    
    /**
     * Envio de recordatorio a encargado secundario
     * @param app\models\Cita $cita
     * @param string $articulo Nombre y abreviatura médica
     * @param string $linkTeleconsulta url de medio de teleconsulta
     */
    private function recordatorioEmailEncargado($cita, $articulo, $linkTeleconsulta){
        \yii::$app->mailer->compose('recordatorio-cita-encargado',['model' => $cita, 'articulo'=>$articulo, 'linkTeleconsulta' => $linkTeleconsulta ])
        ->setFrom(['citas@oliviahealth.com' => 'Olivia Health'])
        ->setTo($cita->paciente->email_encargado_sec)
        ->setSubject("Recordatorio de " . $articulo)
        ->send();
        $this->guardarBitacora($cita->id, $cita->estado, true, false, BitacoraCitaMensaje::ES_RECORDATORIO);  
    }
    
    /*
     * @param array $recSub Recordatorios de suscripción
     * @param array $confRecSub Configuración de recordatorios de suscripción
     * @return boolean
     */
    private function tiemposComunicacion($recSub,$confRecSub){
        if((in_array('Primer recordatorio', $recSub) && in_array('1° Recordatorio', $confRecSub)) ||
           (in_array('Segundo recordatorio', $recSub) && in_array('2° Recordatorio', $confRecSub))||
           (in_array('Tercer recordatorio', $recSub) && in_array('3° Recordatorio', $confRecSub))){
            return true;
        }
        
        return false;
    }
    
    
    public function actionSms()
    {
        $recordatorioSus = []; 
        $confRecSub = []; 
        $strEnvioSMS = \app\models\Configuracion::findOne(['llave' => 'envio_global_sms'])->valor;
        $envio_sms = boolval($strEnvioSMS);
        $count = 0;
        if($envio_sms){
            $username = \yii::$app->params["clickSendU"];
            $password = \yii::$app->params["clickSendP"];
            $csConfig = Configuration::getDefaultConfiguration()
                    ->setUsername($username)
                    ->setPassword($password);
            $csApi = new SMSApi(new Client(['verify' => false]),$csConfig);
            $smsCollector = new SmsMessageCollection();
            $shortUrlServer = \Yii::$app->params['shortUrlServer'];
            $citas = CitaRepository::citasNotificacion(CitaRepository::SMS);
            $count = count($citas);
            $messages = [];
            foreach($citas as $cita){
                $ids = $cita->id_suscripcion;
                if(!array_key_exists("sub_$ids", $recordatorioSus)){
                    $recordatorioSus["sub_"."$ids"] = CitaRepository::recordatoriosCita($ids, CitaRepository::EMAIL);                    
                }
                if(!array_key_exists("sub_$ids", $confRecSub)){
                    $confRecSub["sub_"."$ids"] = explode('|',SesionUtils::getValorLlave('tiempos_de_comunicacion', $ids)->valor);                    
                }
                $llave = SesionUtils::getValorLlave('permitir_reprogramacion_paciente', $ids);
                $confComunicacion = explode('|',SesionUtils::getValorLlave('comunicacion_paciente', $ids)->valor);
                $horas = Utils::diferenciaHoras($cita->fechaDB);
                $horasReprogramar = SesionUtils::getValorLlave('horas_reprogramacion_cita', $ids)->valor;
                $limiteHoras = (int)$horasReprogramar * 60;
                $articulo = SesionUtils::armarArticulo($cita->id_suscripcion, true, false);
                $urlCita = $cita->estado == Cita::CONFIRMADA ? new UrlCita() : UrlCitaRepository::ObtenerUrlCitaPorCita($cita->id);
                $fechaCita = \date('d/m/Y', strtotime($cita->fechaDB));
                $horaCita = \date('H:i', strtotime($cita->fechaDB));
                
                $linkTeleconsulta = ($cita->suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL)
                        ? SesionUtils::getValorLlave('link_teleconsulta', $cita->id_suscripcion)->valor
                        : SesionUtils::getValorLlave('link_teleconsulta', $cita->id_suscripcion,$cita->id_clinica)->valor;
                
                if(in_array('sms', $confComunicacion) && $cita->paciente->celular_encargado_sec != null){
                    $messages[] = $this->recordatorioSmsEncargado($cita->id, $cita->estado, $cita->paciente->nombreCorto, $cita->paciente->celular_encargado_sec, $horaCita, $fechaCita, $articulo);
                }
                if(in_array('sms', $confComunicacion) && $cita->paciente->celular != null && $this->tiemposComunicacion($recordatorioSus["sub_$ids"],$confRecSub["sub_$ids"])){
                    $paciente = $cita->paciente;
                    $link = $shortUrlServer.'?'.$urlCita->llave;
                    $confirm_repro = (boolval($llave->valor) && ($horas > $limiteHoras)) ? 'confirmar o reprogramar' : 'confirmar';
                    $mensaje = $cita->estado == Cita::CONFIRMADA ? 'Hola, recuerda que confirmaste tu cita del '.$fechaCita.' a las '.$horaCita.' con '.$articulo
                            .(($cita->estado == Cita::CONFIRMADA && $cita->tipo_cita == Cita::CITA_EN_LINEA ) ? ' por medio de '.$linkTeleconsulta  : '')
                                : 'Hola, click aqui '.$link.' para '.$confirm_repro.' tu cita del '.$fechaCita.' a las '.$horaCita.' con '.$articulo;
                    $sms = new SmsMessage();
                    $sms->setBody($mensaje);
                    $sms->setTo($paciente->celular);
                    $sms->setSource("sdk");
                    $messages[] = $sms;
                    $this->guardarBitacora($cita->id, $cita->estado, false, true, BitacoraCitaMensaje::ES_RECORDATORIO);
                }

        }
        
        if(count($messages) > 0){
            $smsCollector->setMessages($messages);
            $result = $csApi->smsSendPost($smsCollector);
        }
        $this->GuardarCronLog('recordatorio/sms', $count);
        return ExitCode::OK;

    }    
    
    }
    
    /**
     * Establecer el mensaje a enviar al encargado secundario
     * @param int $idCita id de cita para bitacora
     * @param int $estadoCita estado de cita para bitacora
     * @param string $nombrePaciente Nombre de paciente
     * @param string $celular celular
     * @param string $horaCita Hora de la cita 
     * @param string $fechaCita Fecha de la cita  
     * @param string $articulo Nombre y prefijo médico
     */
    private function recordatorioSmsEncargado($idCita,$estadoCita,$nombrePaciente,$celular,$horaCita,$fechaCita,$articulo){
        $mensaje = ucfirst($articulo).' le recuerda que '.$nombrePaciente.' tiene una cita el '.$fechaCita.' a las '.$horaCita;
        $sms = new SmsMessage();
        $sms->setBody($mensaje);
        $sms->setTo($celular);
        $sms->setSource("sdk");
        $this->guardarBitacora($idCita, $estadoCita, false, true, BitacoraCitaMensaje::ES_RECORDATORIO);
        return $sms;
    }

    
    private function guardarBitacora($idCita,$estado,$esMail,$esSMS, $tipo){
        $bitacoraCita = new BitacoraCitaMensaje();
        $bitacoraCita->fecha = \date("Y-m-d H:i:s");
        $bitacoraCita->id_cita = $idCita;
        $bitacoraCita->estado_cita = $estado;
        $bitacoraCita->es_correo = $esMail;
        $bitacoraCita->es_sms = $esSMS;
        $bitacoraCita->tipo = $tipo;
        $bitacoraCita->save();
    }

    private function GuardarCronLog($cron_name,$rows = 0){
        $cron = new CronLog();
        $cron->app_date = \date("Y-m-d H:i:s");
        $cron->cron_name = $cron_name;
        $cron->rows_count = $rows;
        $cron->save();
    }
}
