<?php

namespace app\commands;

use yii\console\Controller;
use yii\console\ExitCode;
use app\models\cron\CronLog;
use yii\db\Expression;
use app\models\UrlCita;

class MantenimientoController extends Controller {

    public function actionLimpiarCron() {
        $fecha = \date('Y-m-d H:i:s');
        $crons = CronLog::deleteAll(['BETWEEN',
                    new Expression('DATE(app_date)'),
                    new Expression('DATE_ADD(\'' . $fecha . '\',INTERVAL -10 DAY)'),
                    new Expression('DATE_ADD(\'' . $fecha . '\',INTERVAL -5 DAY)')
        ]);
        return ExitCode::OK;
    }

    public function actionLimpiarTokens() {
        $fecha = \date('Y-m-d H:i:s');
        $maxToken = \Yii::$app->params['maxTimeToken'];
        $urlCitas = UrlCita::deleteAll(['BETWEEN',
                    new Expression('fecha'),
                    new Expression('DATE_ADD(\'' . $fecha . '\',INTERVAL -15 DAY)'),
                    new Expression('DATE_ADD(\'' . $fecha . '\',INTERVAL -' . $maxToken . ' HOUR)')
        ]);
        return ExitCode::OK;
    }

}
