<?php

namespace app\commands;

use yii\console\Controller;
use yii\console\ExitCode;
use app\models\Suscripcion;
use Stripe\SubscriptionItem;
use Stripe\Subscription;
use Stripe\Stripe;

class FacturacionController extends Controller
{
    
    public function actionRegistrarUso()
    {

        $secretStripeKey = \Yii::$app->params['strSKey'];
        Stripe::setApiKey($secretStripeKey);
        $suscripciones = Suscripcion::find()->where(['activa' => 1])
                ->all();
        $time = time();
        //$time = 1580945400;
        $today = strtotime(date("Y-m-d 00:00",$time));
        $start_date = date("Y-m-d H:i", strtotime('-59 minute', $today));
        $end_date = date("Y-m-d", $today) . ' 23:00';
        $notificacion = "time: " . \date('Y-m-d H:i:s',$time) . " start_date: " . $start_date . " - end_date: " . $end_date . "<br/>";
        foreach ($suscripciones as $suscripcion){
            $total = $suscripcion->plan->tipo == \app\models\Plan::TIPO_X_CITAS 
                    ? $suscripcion->getTotalCitasNotificadas($start_date,$end_date) 
                    : $suscripcion->getTotalMensajesEnviados($start_date,$end_date);
            if($total > 0){
                $formaPago = $suscripcion->usuario->formaPago;
                if($formaPago != null){
                    $notificacion .= "suscripcion: " . $suscripcion->usuario->nombre_usuario . " total: " . $total;
                    $subscription_item_id = Subscription::retrieve($formaPago->subcription_id)->items->data[0]->id;
                    $res = SubscriptionItem::createUsageRecord(
                      $subscription_item_id,
                      [
                        'quantity' => $total,
                        'timestamp' => $time, //$this->ayerMediaNoche(),
                        'action' => "increment",
                      ]
                    );
                }
            }
        }
        return ExitCode::OK;
    }
    
    
    private function ayerMediaNoche(){
        
        $time = time();
        $ayer = (strtotime( '-1 day' , $time) );
        $beginOfDay = strtotime("today", $ayer);
        $endOfDay   = strtotime("tomorrow", $beginOfDay) - 1;
        return $endOfDay;
    }
    
}
