<?php

namespace app\behaviors;

use yii\base\Behavior;
use yii\db\ActiveRecord;
use app\models\repositories\PacienteRepository;

class PacienteLogableBehavior extends Behavior {

    private $_oldattributes = [];

    
    public function events()
    {
        return [
            ActiveRecord::EVENT_AFTER_UPDATE => 'afterUpdate',
        ];
    }
    
    public function afterUpdate($event) {
        $own = $this->owner;
        $newattributes = $own->getAttributes();
        $oldattributes = $event->changedAttributes;
        foreach ($newattributes as $name => $value) {
            if(!empty($oldattributes) && array_key_exists($name, $oldattributes)){
                $old =  $oldattributes[$name];
                if ($value != $old && ($name == 'estado' || $name == 'id_grupo' || $name == 'id_clinica')) {
                    $usuario = \Yii::$app->user->identity;
                    $suscripcion = $usuario->suscripcion;
                    PacienteRepository::GuardarBitacoraPaciente($own->getPrimaryKey(), $newattributes['estado'], $suscripcion,$newattributes['id_clinica'], $newattributes['id_grupo'],$usuario->id);
                }
            }
        }
    }
  
    public function afterFind($event) {
        // Save old values
        $this->setOldAttributes($this->Owner->getAttributes());
    }

    public function getOldAttributes() {
        return $this->_oldattributes;
    }

    public function setOldAttributes($value) {
        $this->_oldattributes = $value;
    }

}
