<?php
/**
 * @link http://www.yiiframework.com/
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @license http://www.yiiframework.com/license/
 */

namespace app\assets;

use yii\web\AssetBundle;

/**
 * Main application asset bundle.
 *
 * @author Qiang Xue <qiang.xue@gmail.com>
 * @since 2.0
 */
class ViewCitaAsset extends AssetBundle
{
    public $basePath = '@webroot';
    public $baseUrl = '@web';
    public $css = [
        'css/view-cita-seguimiento.css',
    ];
    public $js = [
        'js/view-cita.js?f="2021-12-29"',
        'js/crear-seguimiento.js',
        'js/confirmar-cita.js',
        'js/cobro-cita.js'
    ];
    public $depends = [
        'yii\web\JqueryAsset',
        'app\themes\metronic\assets\BootstrapDatepickerAssets',
        'app\themes\metronic\assets\BlockUIAssets',
    ];
}
