<?php
/**
 * @link http://www.yiiframework.com/
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @license http://www.yiiframework.com/license/
 */

namespace app\assets;

use yii\web\AssetBundle;

/**
 * Main application asset bundle.
 *
 * @author Qiang Xue <qiang.xue@gmail.com>
 * @since 2.0
 */
class NotificacionesAsset extends AssetBundle
{
    public $basePath = '@webroot';
    public $baseUrl = '@web';
    public $css = [
        'css/view-cita-seguimiento.css'
    ];
    public $js = [
        'js/notificaciones.js',
        'js/confirmar-cita.js',
        'js/solicitud-cita-web.js'
    ];
    public $depends = [
        'yii\web\JqueryAsset',
        'app\themes\metronic\assets\BootstrapDatepickerAssets',
        'app\themes\metronic\assets\BlockUIAssets'
    ];
}
